% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RecreateLibrary.R
\name{RecreateLibrary}
\alias{RecreateLibrary}
\title{Recreate R Library}
\usage{
RecreateLibrary(current_version = c("old", "new"), file = "packagelist.txt",
  repos = getOption("repos"))
}
\arguments{
\item{current_version}{'character'.
Current version of the \R installation.
Specify as \code{"old"} when running in the older installation,
and \code{"new"} in the freshly installed version.}

\item{file}{'character'.
Name of the file for writing (or reading) the list of package names.}

\item{repos}{'character'.
Vector of base URL(s) of the repositories to use;
only required if \code{current_version = "new"}.}
}
\description{
This function can be used to recreate an existing library on a new installation of \R.
}
\examples{
# Run on old version of R
RecreateLibrary()

\dontrun{
# Run on new version of R (assumes working directory has not changed)
RecreateLibrary("new", repos = c(CRAN = "https://cloud.r-project.org/",
                                 GRAN = "https://owi.usgs.gov/R"))
}

unlink("packagelist.txt")

}
\seealso{
\code{\link[utils]{update.packages}}, \code{\link[utils]{install.packages}}
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{utilities}
