% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_metadata.R
\name{validate_metadata}
\alias{validate_metadata}
\title{Validate Metadata}
\usage{
validate_metadata(file, destdir = NULL, opts = c("e", "h", "f"), error = FALSE)
}
\arguments{
\item{file}{'character' string.
Path to a XML formatted metadata file that contains the information for a USGS data release.}

\item{destdir}{'character' string.
Destination directory to write files, with tilde-expansion performed.
Defaults to the \code{file} directory.}

\item{opts}{'character' vector.
Output option codes.
Choose from one or more of the following codes:
\code{e} direct syntax errors to file,
\code{t} write indented ASCII text file,
\code{h} write outline-style HTML file,
\code{f} write FAQ-style HTML file,
\code{s} write Standard Generalized Markup Language (SGML) file,
\code{x} write XML file, and
\code{d} write Directory Interchange Format (DIF) file.}

\item{error}{'logical' flag.
Whether to stop execution if validation errors are found (default is \code{FALSE}) or
mp executable is not accessible.}
}
\value{
Invisibly returns a flag indicating whether validation errors were found.
Returns \code{NA} if mp executable is not accessible.
}
\description{
Validates the Extensible Markup Language (XML) formatted metadata
that is intended for a USGS data release.
Checks your \href{https://www.fgdc.gov/metadata/csdgm/}{FGDC}-compatible geospatial metadata record using
\href{https://geology.usgs.gov/tools/metadata/tools/doc/mp.html}{mp (metadata parser)}.
Requires the \code{mp} executable is on your path.
\href{https://geology.usgs.gov/tools/metadata/#download}{Download} and install the software if not found.
}
\examples{
validate_metadata(
  file = system.file("extdata/test.xml", package = "inldata"),
  destdir = "validate"
)
list.files("validate")

unlink("validate", recursive = TRUE)
}
\seealso{
\code{\link{make_data_release}} function for creating a USGS data release.
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{internal}
