% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bru.spatial.R, R/deprecated.R, R/environment.R,
%   R/mappers.R, R/utils.R
\name{stransform}
\alias{stransform}
\alias{inlabru-deprecated}
\alias{init.tutorial}
\alias{ibm_valid_input}
\alias{ibm_amatrix.bru_mapper_inla_mesh_2d}
\alias{ibm_amatrix.bru_mapper_inla_mesh_1d}
\alias{ibm_amatrix.bru_mapper_index}
\alias{ibm_amatrix.bru_mapper_linear}
\alias{ibm_amatrix.bru_mapper_matrix}
\alias{ibm_amatrix.bru_mapper_factor}
\alias{bru_mapper_offset}
\alias{ibm_n.bru_mapper_offset}
\alias{ibm_values.bru_mapper_offset}
\alias{ibm_amatrix.bru_mapper_offset}
\alias{ibm_amatrix.bru_mapper_multi}
\alias{ibm_amatrix.bru_mapper_collect}
\alias{eval_SpatialDF}
\title{Deprecated functions in inlabru}
\usage{
stransform(splist, crs)

init.tutorial()

ibm_valid_input(...)

\method{ibm_amatrix}{bru_mapper_inla_mesh_2d}(...)

\method{ibm_amatrix}{bru_mapper_inla_mesh_1d}(...)

\method{ibm_amatrix}{bru_mapper_index}(...)

\method{ibm_amatrix}{bru_mapper_linear}(...)

\method{ibm_amatrix}{bru_mapper_matrix}(...)

\method{ibm_amatrix}{bru_mapper_factor}(...)

bru_mapper_offset(...)

\method{ibm_n}{bru_mapper_offset}(...)

\method{ibm_values}{bru_mapper_offset}(...)

\method{ibm_amatrix}{bru_mapper_offset}(...)

\method{ibm_amatrix}{bru_mapper_multi}(...)

\method{ibm_amatrix}{bru_mapper_collect}(...)

eval_SpatialDF(...)
}
\arguments{
\item{splist}{list of Spatial* objects}

\item{crs}{Coordinate reference system to change to}

\item{\dots}{Usually passed on to other methods}
}
\value{
\code{stransform}
}
\description{
These functions still attempt to do their job, but will be removed in a
future version.
}
\section{Functions}{
\itemize{
\item \code{stransform()}: Coordinate transformation for spatial objects

This is a wrapper for the \link[sp:spTransform]{spTransform} function provided by the \code{sp} package.
Given a spatial object (or a list thereof) it will transform the coordinate system according
to the parameter \code{crs}. In addition to the usual spatial objects this function is
also capable of transforming \code{INLA::inla.mesh} objects that are equipped with a coordinate
system. Returns a list of Spatial* objects.

Deprecated in favour of the \code{fm_transform} methods.

\item \code{init.tutorial()}: Global setting for tutorial sessions.

Use \code{\link[=bru_options_set]{bru_options_set()}} to set specific
options instead instead.  In versions <= 2.1.15, this function set the INLA
integration strategy to "eb" to speed up calculations. This is normally not
needed since version 2.2.0, since the only the final iteration will use
other than "eb".

\item \code{ibm_valid_input()}: Use case changed to \code{\link[=ibm_invalid_output]{ibm_invalid_output()}}

\item \code{ibm_amatrix(bru_mapper_inla_mesh_2d)}: Replaced by \code{\link[=ibm_jacobian]{ibm_jacobian()}}

\item \code{ibm_amatrix(bru_mapper_inla_mesh_1d)}: Replaced by \code{\link[=ibm_jacobian]{ibm_jacobian()}}

\item \code{ibm_amatrix(bru_mapper_index)}: Replaced by \code{\link[=ibm_jacobian]{ibm_jacobian()}}

\item \code{ibm_amatrix(bru_mapper_linear)}: Replaced by \code{\link[=ibm_jacobian]{ibm_jacobian()}}

\item \code{ibm_amatrix(bru_mapper_matrix)}: Replaced by \code{\link[=ibm_jacobian]{ibm_jacobian()}}

\item \code{ibm_amatrix(bru_mapper_factor)}: Replaced by \code{\link[=ibm_jacobian]{ibm_jacobian()}}

\item \code{bru_mapper_offset()}: Creates a \code{\link[=bru_mapper_const]{bru_mapper_const()}} mapper.

\item \code{ibm_n(bru_mapper_offset)}: Replaced by \link{bru_mapper_const} methods

\item \code{ibm_values(bru_mapper_offset)}: Replaced by \link{bru_mapper_const} methods

\item \code{ibm_amatrix(bru_mapper_offset)}: Replaced by \link{bru_mapper_const} methods

\item \code{ibm_amatrix(bru_mapper_multi)}: Replaced by \code{\link[=ibm_jacobian]{ibm_jacobian()}}

\item \code{ibm_amatrix(bru_mapper_collect)}: Replaced by \code{\link[=ibm_jacobian]{ibm_jacobian()}}

\item \code{eval_SpatialDF()}: Replaced by the generic \code{\link[=eval_spatial]{eval_spatial()}}

}}
\examples{
\donttest{
# Load Gorilla data
data("gorillas", package = "inlabru")

# Take the mesh and transform it to latitude/longitude
tmesh <- stransform(gorillas$mesh, crs = CRS("+proj=longlat"))

# Compare original and transformed mesh

if (require(ggplot2, quietly = TRUE)) {
  multiplot(
    ggplot() +
      gg(gorillas$mesh) +
      ggtitle("Original mesh"),
    ggplot() +
      gg(tmesh) +
      ggtitle("Transformed mesh")
  )
}
}

\dontrun{
# Note: Only run this if you want to change the inlabru options for this session

# Determine current bru defaults:
bo <- bru_options_get()

init.tutorial()

# Check if it worked:
bru_options_get("control.inla")
}

}
\author{
Finn Lindgren \email{finn.lindgren@gmail.com}

Fabian E. Bachl \email{bachlfab@gmail.com}
}
