% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot.R
\name{gg.RasterLayer}
\alias{gg.RasterLayer}
\title{Geom for RasterLayer objects}
\usage{
\method{gg}{RasterLayer}(data, mapping = aes_string(x = "x", y = "y",
  fill = "layer"), ...)
}
\arguments{
\item{data}{A RasterLayer object.}

\item{mapping}{aesthetic mappings created by \link{aes} or \link{aes_}. These are passed on to \link{geom_tile}.}

\item{...}{Arguments passed on to \link{geom_tile}.}
}
\value{
An object returned by \link{geom_tile}
}
\description{
This function takes a RasterLayer object, converts it into a SpatialPixelsDataFrame and
uses \link{geom_tile} to plot the data.
}
\details{
This function requires the `raster` package.
}
\examples{
# Some features require the raster and spatstat.data packages.
if (require("spatstat.data", quietly = TRUE) &&
    require("raster", quietly = TRUE)) {

# Load Gorilla data
data("gorillas", package = "spatstat.data")

# Convert elevation covariate to RasterLayer

elev = as(gorillas.extra$elevation, "RasterLayer")

# Plot the elevation

ggplot() + gg(elev)

}
}
\seealso{
Other geomes for Raster data: \code{\link{gg}},
  \code{\link{gm}}
}
\concept{geomes for Raster data}
