% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conditional_dependency.R
\name{conditional_dependency}
\alias{conditional_dependency}
\alias{conditional_dependency.explainer}
\alias{conditional_dependency.default}
\alias{conditional_dependency.ceteris_paribus_explainer}
\alias{local_dependency}
\title{Conditional Dependency Profiles}
\usage{
conditional_dependency(x, ...)

\method{conditional_dependency}{explainer}(x, variables = NULL,
  N = 500, variable_splits = NULL, grid_points = 101, ...,
  variable_type = "numerical")

\method{conditional_dependency}{default}(x, data,
  predict_function = predict, label = class(x)[1], variables = NULL,
  N = 500, variable_splits = NULL, grid_points = 101, ...,
  variable_type = "numerical")

\method{conditional_dependency}{ceteris_paribus_explainer}(x, ...,
  variables = NULL)

local_dependency(x, ...)
}
\arguments{
\item{x}{an explainer created with function \code{DALEX::explain()}, an object of the class \code{ceteris_paribus_explainer}
or a model to be explained.}

\item{...}{other parameters}

\item{variables}{names of variables for which profiles shall be calculated.
Will be passed to \code{\link{calculate_variable_split}}. If \code{NULL} then all variables from the validation data will be used.}

\item{N}{number of observations used for calculation of partial dependency profiles. By default 500.}

\item{variable_splits}{named list of splits for variables, in most cases created with \code{\link{calculate_variable_split}}.
If \code{NULL} then it will be calculated based on validation data avaliable in the \code{explainer}.}

\item{grid_points}{number of points for profile. Will be passed to \code{\link{calculate_variable_split}}.}

\item{variable_type}{a character. If \code{numerical} then only numerical variables will be calculated.
If \code{categorical} then only categorical variables will be calculated.}

\item{data}{validation dataset, will be extracted from \code{x} if it's an explainer
NOTE: It is best when target variable is not present in the \code{data}}

\item{predict_function}{predict function, will be extracted from \code{x} if it's an explainer}

\item{label}{name of the model. By default it's extracted from the \code{class} attribute of the model}
}
\value{
an object of the class \code{aggregated_profile_explainer}
}
\description{
Conditional Dependency Profiles (aka Local Profiles) average localy Ceteris Paribus Profiles.
Function 'conditional_dependency' calls 'ceteris_paribus' and then 'aggregate_profiles'.
}
\details{
Find more detailes in \href{https://pbiecek.github.io/PM_VEE/conditionalProfiles.html}{Local Dependency Profiles Chapter}.
}
\examples{
library("DALEX")

model_titanic_glm <- glm(survived ~ gender + age + fare,
                         data = titanic_imputed, family = "binomial")

explain_titanic_glm <- explain(model_titanic_glm,
                               data = titanic_imputed[,-8],
                               y = titanic_imputed[,8],
                               verbose = FALSE)

cdp_glm <- conditional_dependency(explain_titanic_glm,
                                  N = 150, variables = c("age", "fare"))
head(cdp_glm)
plot(cdp_glm)

\donttest{
library("randomForest")

model_titanic_rf <- randomForest(survived ~.,  data = titanic_imputed)

explain_titanic_rf <- explain(model_titanic_rf,
                              data = titanic_imputed[,-8],
                              y = titanic_imputed[,8],
                              verbose = FALSE)

cdp_rf <- conditional_dependency(explain_titanic_rf, N = 200, variable_type = "numerical")
plot(cdp_rf)

cdp_rf <- conditional_dependency(explain_titanic_rf, N = 200, variable_type = "categorical")
plotD3(cdp_rf, variable_type = "categorical", label_margin = 80, scale_plot = TRUE)
}

}
\references{
Predictive Models: Visual Exploration, Explanation and Debugging \url{https://pbiecek.github.io/PM_VEE}
}
