% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_indicator_valid.R
\name{is_indicator_valid}
\alias{is_indicator_valid}
\title{Check if indicator exists}
\usage{
is_indicator_valid(indicator, lang = "PT")
}
\arguments{
\item{indicator}{INE indicator ID as a 7 character string. Example: "0010003".}

\item{lang}{One of "PT" or "EN". Default is "PT".}
}
\value{
TRUE if indicator exists, otherwise FALSE.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} \cr
Check if the indicator exists and is callable via the INE API. \cr
Indicator ID can be found in the url under the 'indOcorrCod' query parameter when browsing the website. \cr
Example: https://www.ine.pt/xportal/xmain?xpid=INE&xpgid=ine_indicadores&indOcorrCod=0010003&contexto=bd&selTab=tab2
}
\examples{
is_indicator_valid("0011823")
}
