% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render.R
\name{Render}
\alias{Render}
\title{Render}
\description{
Class to render output for the simulation
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Render$new()}}
\item \href{#method-set_default}{\code{Render$set_default()}}
\item \href{#method-render}{\code{Render$render()}}
\item \href{#method-to_dataframe}{\code{Render$to_dataframe()}}
\item \href{#method-clone}{\code{Render$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialise a renderer for the simulation, creates the default state
renderers
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Render$new(timesteps)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{timesteps}}{number of timesteps in the simulation}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_default"></a>}}
\if{latex}{\out{\hypertarget{method-set_default}{}}}
\subsection{Method \code{set_default()}}{
Set a default value for a rendered output
renderers
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Render$set_default(name, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{the variable to set a default for}

\item{\code{value}}{the default value to set for a variable}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-render"></a>}}
\if{latex}{\out{\hypertarget{method-render}{}}}
\subsection{Method \code{render()}}{
Update the render with new simulation data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Render$render(name, value, timestep)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{the variable to render}

\item{\code{value}}{the value to store for the variable}

\item{\code{timestep}}{the timestep of the data point}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-to_dataframe"></a>}}
\if{latex}{\out{\hypertarget{method-to_dataframe}{}}}
\subsection{Method \code{to_dataframe()}}{
Return the render as a \code{\link[base]{data.frame}}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Render$to_dataframe()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Render$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
