% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incidence.R
\name{inccounts}
\alias{inccounts}
\title{Incidence and incidence difference statistics from trinomial counts of HIV and recency}
\usage{
inccounts(N, N_H, N_testR, N_R, DE_H = 1, DE_R = 1, BS_Count = 10000,
  Boot = FALSE, alpha = 0.05, BMest = "same.test", MDRI, RSE_MDRI, FRR,
  RSE_FRR, BigT = 730, Covar_HR = 0)
}
\arguments{
\item{N}{Counts of total survey sample size(s) (vector/integer).}

\item{N_H}{Number of HIV positive found in survey(s) (vector/integer).}

\item{N_testR}{Number tested for recency in survey(s) (vector/integer).}

\item{N_R}{Number of recent cases in survey(s) (vector/integer).}

\item{DE_H}{Design effect of HIV prevalence test (vector/numeric), greater than or equal to 1. If multiple surveys are entered but only one design effect is specified, function assumes entered design effect is identical for both surveys.}

\item{DE_R}{Design effect of recency test (vector/numeric), greater than or equal to 1. If multiple surveys are entered but only one design effect is specified, function assumes entered design effect is identical for both surveys.}

\item{BS_Count}{Specifies number of bootstrap samples for bootstrapped confidence intervals of incidence.}

\item{Boot}{True/False variable indicating whether variance of point estimates is to be calculated by Empirical Bootstrapping (TRUE) or Delta Method (FALSE), the default setting.}

\item{alpha}{test rejection threshold.}

\item{BMest}{Biomarker estimation by one the 3 options 'same.test'(=default), 'FRR.indep', 'MDRI.FRR.indep' (string).}

\item{MDRI}{mean duration of recent infection [days] (vector/integer).}

\item{RSE_MDRI}{Relative standard error of MDRI [days] (vector/integer).}

\item{FRR}{False recent rate (vector/integer).}

\item{RSE_FRR}{Relative standard error of FRR (vector/integer).}

\item{BigT}{Cut point in days of recency used in biomarker assay to test recency in a given prevalence survey.}

\item{Covar_HR}{Covariance of probability of being postive and being categorized recent from survey (or as a vector for multiple surveys).}
}
\value{
Incidence estimate, annual risk of infection, confidence interval, relative standard error of estimate and of assay characteristics MDRI and FRR. If multiple surveys are entered, function returns said results, as well as estimates of incidence  differences, confidence intervals of differences, difference relative standard errors, and p-values testing the hypothesis that the difference in incidence measures are zero. Theoretical relative standard error of incidence and incidence difference at infinite sample size is returned only if Boot = FALSE, as that calculation relies on the asymptotic behavior of components of the Delta method approximation, and is not calculable from bootstrapped values.
}
\description{
Incidence and incidence difference statistics from trinomial counts of HIV and recency
}
\details{
Implements assay-based incidence estimation through cross-sectional prevalence and recency of infection tests as described by Kassanjee, et al. 'A new general biomarker-based incidence estimator,' \emph{Epidemiology} (2012). Function parameters must be specified to include assay test characteristics and survey results as proportions. Confidence intervals are computed via Delta method approximation, except when Boot=TRUE is specified, in which case confidence intervals are generated by empirical bootstrap resampling. Inputs must be in appropriate ranges for appropriate units. Extreme input values may make calculation impossible, and if entered will elicit error notices.
The package contains long form documentation in the form of vignettes that cover the use of the main fucntions. Use browseVignettes(package="inctools") to access them.
}
\examples{
inccounts(N = c(5000) ,N_H = 1000, N_testR = 1000, N_R = 70,
Boot = FALSE, BMest = 'MDRI.FRR.indep', MDRI = 200, RSE_MDRI = 0.05,
FRR = 0.01, RSE_FRR = 0.2, BigT = 730)


inccounts(N = c(4000,4000,4050) ,N_H = c(1010,1000,900),
N_testR = c(1000,1000,880), N_R = c(60,70,50), Boot = TRUE,
BMest = 'same.test', MDRI = 210, RSE_MDRI = 0.05, FRR = 0.005,
RSE_FRR = 0.19, BigT = 700)


inccounts(N = c(4000,4000) ,N_H = c(1050,1090),
N_testR = c(1000,1000), N_R = c(60,67), Boot = FALSE, BMest = 'FRR.indep',
MDRI = 220, RSE_MDRI = 0.05, FRR = c(0.005,0.005), RSE_FRR = 0.19,
BigT = 610)

}
