% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dim.R, R/get_interval.R, R/get_n.R,
%   R/get_timespan.R
\name{dim.incidence}
\alias{dim.incidence}
\alias{get_interval}
\alias{get_interval.default}
\alias{get_interval.incidence}
\alias{get_n}
\alias{get_n.default}
\alias{get_n.incidence}
\alias{get_timespan}
\alias{get_timespan.default}
\alias{get_timespan.incidence}
\title{Access various elements of an incidence object}
\usage{
\method{dim}{incidence}(x)

get_interval(x, ...)

\method{get_interval}{default}(x, ...)

\method{get_interval}{incidence}(x, integer = TRUE, ...)

get_n(x)

\method{get_n}{default}(x)

\method{get_n}{incidence}(x)

get_timespan(x)

\method{get_timespan}{default}(x)

\method{get_timespan}{incidence}(x)
}
\arguments{
\item{x}{an \link{incidence} object.}

\item{...}{Unused}

\item{integer}{When \code{TRUE} (default), the interval will be converted to an
integer vector if it is stored as a character in the incidence object.}
}
\value{
\itemize{
\item \code{dim()} the dimensions in the number of bins and number of groups
}

\itemize{
\item \code{get_interval()} if \code{integer = TRUE}: an integer vector, otherwise: the
value stored in \code{x$interval}
}

\itemize{
\item \code{get_n()} The total number of cases stored in the object
}

\itemize{
\item \code{get_timespan()}: an \code{integer} denoting the timespan represented by the
incidence object.
}
}
\description{
Access various elements of an incidence object
}
\examples{

set.seed(999)
dat <- as.Date(Sys.Date()) + sample(-3:50, 100, replace = TRUE)
x <- incidence(dat, interval = "month")

# the value stored in the interval element
get_interval(x)

# the numeric value of the interval in days
get_interval(x, integer = FALSE)

# the number of observations in the object
get_n(x)

# the length of time represented
get_timespan(x)

# the number of groups
ncol(x)

# the number of bins (intervals)
nrow(x)
}
\seealso{
\itemize{
\item \code{\link[=get_counts]{get_counts()}} to access the matrix of counts
\item \code{\link[=get_dates]{get_dates()}} to access the dates on the right, left, and center of the
interval.
\item \code{\link[=group_names]{group_names()}} to access and possibly re-name the groups
}
}
\keyword{accessors}
