% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeSummaryStatisticsTable.R
\name{computeSummaryStatisticsTableTotal}
\alias{computeSummaryStatisticsTableTotal}
\title{Compute summary statistics total table.}
\usage{
computeSummaryStatisticsTableTotal(
  data,
  colVar = NULL,
  colVarTotal = colVar,
  rowVarTotal = NULL,
  var = NULL,
  varLab = getLabelVar(var, data = data, labelVars = labelVars),
  colTotalLab = "Total",
  colInclude0 = FALSE,
  colTotalInclude = FALSE,
  dataTotalCol = NULL,
  colVarDataLevels = NULL,
  colVarLevels = NULL,
  subjectVar = "USUBJID",
  labelVars = NULL,
  msgLabel = "total"
)
}
\arguments{
\item{data}{Data.frame with dataset to consider for the summary table.}

\item{colVar}{Character vector with variable(s) to be included in columns.
If multiple variables are specified, the variables should 
be sorted in hierarchical order,
and are included in multi-columns layout.\cr
Use: 'variable' to include the variables to summarize: \code{var}
 (if multiple) in different columns.}

\item{colVarTotal}{Character vector with column(s) considered to compute the total.
This could also contain 'variable'.}

\item{rowVarTotal}{Character vector with row(s) considered to compute the total.
This could also contain 'variable'.}

\item{var}{Character vector with variable(s) of \code{data}, 
to compute statistics on.\cr
If NULL (by default), counts by row/column variable(s) are computed.\cr
To also return counts of the \code{rowVar} in case other \code{var}
are specified, you can include: 'all' in the \code{var}.\cr
Missing values, if present, are filtered 
(also for the report of number of subjects/records).}

\item{colTotalLab}{String, label for the total column  'Total' by default.\cr}

\item{colTotalInclude}{Logical, if TRUE (FALSE by default) include the summary 
statistics across columns in a separated column.}

\item{dataTotalCol}{Data.frame from which the total across columns is 
extracted (in case \code{colTotalInclude} is TRUE).}

\item{colVarLevels}{list with levels of each \code{colVar}}

\item{subjectVar}{String, variable of \code{data} with subject ID,
'USUBJID' by default.}

\item{labelVars}{(optional) Named character vector with label for
the row, column variable(s) or variable(s) to summarize. \cr
Labels specified via dedicated parameter: e.g. 
\code{rowVarLab}, \code{colVarLab}, \code{varLab}
have priority on this parameter.}

\item{msgLabel}{(optional) String with label for the data ('total' by default), 
included in the message/warning for checks.}
}
\value{
data.frame with total table.
}
\description{
Compute summary statistics total table.
}
\author{
Laure Cougnaud
}
\keyword{internal}
