% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impreciseEstimationConditional.R
\name{impestcond}
\alias{impestcond}
\title{Conditional Imprecise Estimation}
\usage{
impestcond(data, event, condition, constraints = NULL)
}
\arguments{
\item{data}{a data.frame obtained as result from an
imprecise imputation e.g. by a call to
\code{\link{impimp}}.}

\item{event}{a list of objects of class \code{"impimp_event"},
specifiying the event of interest. See 'Details'.}

\item{condition}{a list of objects of class \code{"impimp_event"},
specifiying the event to condition on. See 'Details'.}

\item{constraints}{a list of so-called logical constraints or
fixed zeros. Each element must be an object of class
\code{"impimp_event"}. See 'Details' .}
}
\value{
A numeric vector of length 2, where the
first component contains the lower and the second component
the upper conditional probability of the event of interest.
}
\description{
Estimate conditional probability of some events
based on data obtained by imprecise imputation
}
\details{
\code{event} and \code{condition} should each be a list of objects
of class \code{"impmp_event"}, where within each list the set union
of impimp_events is the actual event of interest or conditioning
event, respectively.

By specifying \code{constraints} one can exlude combinations of
imputed values which are deemed impossible, so called
\sQuote{logical constraints} or \sQuote{fixed zeros}.
\code{constraints} should be a list of objects of class
\code{"impimp_event"}.

An object of class \code{"impimp_event"} is obtained as a result
of a call to \code{\link{impimp_event}}.

For \code{event}, \code{condition} and \code{constraints} holds
that overlapping in the resulting events generated by the
individual impimp_events does not have any side effects, besides
a potential decrease in performance.
}
\examples{
A <- data.frame(x1 = c(1,0), x2 = c(0,0),
                y1 = c(1,0), y2 = c(2,2))
B <- data.frame(x1 = c(1,1,0), x2 = c(0,0,0),
                z1 = c(0,1,1), z2 = c(0,1,2))
AimpB <- impimp(A, B, method = "domain")
BimpA <- impimp(B, A, method = "domain")
AB <- rbindimpimp(AimpB, BimpA)

myevent <- list(impimp_event(z1 = 1,z2 = 0),
                impimp_event(z1 = c(0,1), z2 = 1))
cond <- list(impimp_event(x1 = 1))

impestcond(AB, event = myevent, condition = cond)

constr <- list(impimp_event(y1 = 0, z1 = 0))
impestcond(AB, event = myevent, condition = cond,
           constraints = constr)

}
\references{
Dubois, D. and Prade, H. (1992), Evidence, knowledge,
and belief functions, \emph{International Journal of Approximate
Reasoning} \bold{6}(3), 295–319.
}
\seealso{
\code{\link{impimp}}, \code{\link{impimp_event}} for
sepcifying constraints and events; \code{\link{impest}} for
the estimation of unconditional probabilities
}
\keyword{robust}
