% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict_loading}
\alias{predict_loading}
\title{Predict mechanical loading}
\usage{
predict_loading(data, outcome, vector, model)
}
\arguments{
\item{data}{An \code{impactr_data} object, as obtained with
\link[=read_acc]{read_acc()}.}

\item{outcome}{A character string. Can be either "grf" (for ground reaction
force), or "lr" (for loading rate) or "all" (for both mechanical loading
variables).}

\item{vector}{A character string indicating in which acceleration vector to
find the peaks. Can be "resultant", "vertical" or "all".}

\item{model}{A character string indicating which model to use to make
the predictions. The only value supported, currently, is "walking/running".}
}
\value{
An object of class \code{impactr_peaks} with the ground reaction
force and/or loading rate peaks magnitude stored in the columns.
}
\description{
Predict either ground reaction force or loading rate, or both, based on
accelerometer data.
}
\examples{
data <- read_acc(impactr_example("hip-raw.csv"))
data <- specify_parameters(data, acc_placement = "hip", subj_body_mass = 78)
data <- find_peaks(data, vector = "vertical")
predict_loading(
  data,
  outcome = "grf",
  vector = "vertical",
  model = "walking/running"
)
}
