% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{plot_clustered_tsne}
\alias{plot_clustered_tsne}
\title{Plot Clustered t-SNE Results}
\usage{
plot_clustered_tsne(info.norm, cluster_data, settings)
}
\arguments{
\item{info.norm}{A data frame containing t-SNE coordinates (\code{tsne1}, \code{tsne2}) and cluster assignments (\code{pandora_cluster}) for each point.}

\item{cluster_data}{A data frame containing the cluster centroids and labels, with columns \code{tsne1}, \code{tsne2}, \code{label}, and \code{pandora_cluster}.}

\item{settings}{A list of settings for the plot, including:
\itemize{
\item \code{theme}: The ggplot2 theme to use (e.g., \code{"theme_classic"}).
\item \code{colorPalette}: The color palette to use for clusters (e.g., \code{"RdPu"}).
\item \code{pointSize}: The size of points in the plot.
\item \code{fontSize}: The font size used in the plot.
\item \code{legendPosition}: The position of the legend (e.g., \code{"right"}).
\item \code{plot_size}: The size of the plot.
\item \code{aspect_ratio}: The aspect ratio of the plot.
}}
}
\value{
ggplot2 object representing the clustered t-SNE plot.
}
\description{
This function generates a t-SNE plot with cluster assignments using consistent color mappings.
It includes options for plotting points based on their t-SNE coordinates and adding cluster
labels at the cluster centroids. The plot is saved as an SVG file in a temporary directory.
}
\examples{
\dontrun{
# Example usage
plot <- plot_clustered_tsne(info.norm, cluster_data, settings)
print(plot)
}
}
