% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Partial.R
\name{plot.Partial}
\alias{plot.Partial}
\title{Plot Partial Dependence}
\usage{
\method{plot}{Partial}(x, rug = TRUE)
}
\arguments{
\item{x}{A Partial R6 object}

\item{rug}{[logical] Should a rug be plotted to indicate the feature distribution?}
}
\value{
ggplot2 plot object
}
\description{
plot.Partial() plots the results of a Partial object.
}
\examples{
# We train a random forest on the Boston dataset:
if (require("randomForest")) {
data("Boston", package  = "MASS")
rf = randomForest(medv ~ ., data = Boston, ntree = 50)
mod = Predictor$new(rf, data = Boston)

# Compute the partial dependence for the first feature
pdp.obj = Partial$new(mod, feature = "crim")

# Plot the results directly
plot(pdp.obj)
}
}
\seealso{
\link{Partial}
}
