% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/database.R
\name{load_datasets}
\alias{load_datasets}
\title{Loads Time Series Datasets}
\usage{
load_datasets(id, use_cache = TRUE)
}
\arguments{
\item{id}{is character vector of Dataset Series identifier.}

\item{use_cache}{is Boolean, defaults to TRUE, if TRUE it reloads the Dataset
from cached values.}
}
\value{
a dataset object for the time-series identifier, i.e. a list containing
a list 'dimensions' of data.frames with the valid dimensions values, and a
function 'get_series' to retrieve time-series data.
}
\description{
Loads Time Series Datasets
}
\examples{
IFS <- load_datasets("IFS")
DOT <- load_datasets("DOT")

DOT$get_series(freq = "M",
               ref_area ="GB",
               indicator = "TMG_CIF_USD",
               counterpart_area = c("B0","W00"),
               start_period = "2022-01-01",
               end_period = "2022-12-31")

 DTS <- load_datasets(c("DOT","IFS"))

}
