% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversions.R
\name{grayscale}
\alias{grayscale}
\title{Convert an RGB image to grayscale}
\usage{
grayscale(im, method = "Luma", drop = TRUE)
}
\arguments{
\item{im}{an RGB image}

\item{method}{either "Luma", in which case a linear approximation to luminance is used, or "XYZ", in which case the image is assumed to be in sRGB color space and CIE luminance is used.}

\item{drop}{if TRUE returns an image with a single channel, otherwise keep the three channels (default TRUE)}
}
\value{
a grayscale image (spectrum == 1)
}
\description{
This function converts from RGB images to grayscale
}
\examples{
grayscale(boats) \%>\% plot
#In many pictures, the difference between Luma and XYZ conversion is subtle 
grayscale(boats,method="XYZ") \%>\% plot
grayscale(boats,method="XYZ",drop=FALSE) \%>\% dim
}
