% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversions.R
\name{as.data.frame.cimg}
\alias{as.data.frame.cimg}
\title{Convert a pixel image to a data.frame}
\usage{
\method{as.data.frame}{cimg}(x, ..., wide = c(FALSE, "c", "d"))
}
\arguments{
\item{x}{an image of class cimg}

\item{...}{arguments passed to pixel.grid}

\item{wide}{if "c" or "d" return a data.frame that is wide along colour or depth (for example with rgb values along columns). The default is FALSE, with each pixel forming a separate entry.}
}
\value{
a data.frame
}
\description{
This function combines the output of pixel.grid with the actual values (stored in $value)
}
\examples{

#First five pixels
as.data.frame(boats) \%>\% head(5)
#Wide format along colour axis
as.data.frame(boats,wide="c") \%>\% head(5)
}
\author{
Simon Barthelme
}

