% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{display}
\alias{display}
\title{Basic image display.}
\usage{
display(img, col = grDevices::grey.colors(999, 0, 1), ...)
}
\arguments{
\item{img}{A numeric matrix.}

\item{col}{Colour lookup table to use for display.}

\item{...}{Arguments passed to \code{\link[fields:image.plot]{fields::image.plot()}}. These arguments should
be fully named.}
}
\description{
Display an image that has been read in by \code{\link[=read_tif]{read_tif()}} as it would look in
'ImageJ'. This function wraps \code{\link[fields:image.plot]{fields::image.plot()}}.
}
\examples{
img <- read_tif(system.file("img", "Rlogo.tif", package = "ijtiff"))
display(img)  # first channel, first frame
display(img[, , 1, 1])  # first (red) channel, first frame
display(img[, , 2, ])  # second (green) channel, first frame
display(img[, , 3, ])  # third (blue) channel, first frame

}
