% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train_iimi.R
\name{train_iimi}
\alias{train_iimi}
\title{train_iimi()}
\usage{
train_iimi(
  train_x,
  train_y,
  method = "xgb",
  nrounds = 100,
  max_depth = 10,
  gamma = 6,
  ntree = 100,
  k = 5,
  ...
)
}
\arguments{
\item{train_x}{A data frame or a matrix of predictors.}

\item{train_y}{A response vector of labels (needs to be a factor).}

\item{method}{The machine learning method of choice, \verb{Random Forest} or
\code{XGBoost}, or \verb{Elastic Net} model. Default is \code{XGBoost} model.}

\item{nrounds}{Max number of boosting iterations for \code{XGBoost} model. Default
is 100.}

\item{max_depth}{Maximum depth of a tree in \code{XGBoost} model. Default is 10.}

\item{gamma}{Minimum loss reduction required in \code{XGBoost} model. Default is 6.}

\item{ntree}{Number of trees in \verb{Random Forest} model. Default is 100.}

\item{k}{Number of folds. Default is 5.}

\item{\dots}{Other arguments that can be passed to \code{randomForest},
\code{xgboost}, or \code{glmnet}.}
}
\value{
A \verb{Random Forest}, \code{XGBoost}, \verb{Elastic Net} model
}
\description{
Trains a \code{XGBoost} (default), \verb{Random Forest}, or \verb{Elastic Net}
model using user-provided data.
}
\examples{
\dontrun{
df <- convert_rle_to_df(example_cov)
train_x <- df[,-c(1:4)]
train_y = c()
for (ii in 1:nrow(df)) {
  seg_id = df$seg_id[ii]
  sample_id = df$sample_id[ii]
  train_y = c(train_y, example_diag[seg_id, sample_id])
}
trained_model <- train_iimi(train_x = train_x, train_y = train_y)
}




}
