% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lasso.R
\name{setup_lambda}
\alias{setup_lambda}
\title{Set up a lambda sequence}
\usage{
setup_lambda(X, y, family = "gaussian", lambda.min.ratio = 1e-04,
  nlambda = 100)
}
\arguments{
\item{X}{matrix of explanatory variables}

\item{y}{vector of objective variable}

\item{family}{family of regression: "gaussian" (default) or "binomial"}

\item{lambda.min.ratio}{ratio of max lambda and min lambda}

\item{nlambda}{the number of lambda (ignored if lambda is specified)}
}
\value{
lambda
}
\description{
Set up a lambda sequence
}
\examples{
X <- matrix(c(1,2,3,5,4,7,6,8,9,10), nrow=5, ncol=2)
b <- matrix(c(-1,1), nrow=2, ncol=1)
e <- matrix(c(0,-0.1,0.1,-0.1,0.1), nrow=5, ncol=1)
y <- as.numeric(X \%*\% b + e)
setup_lambda(X, y)
}
