% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igrf_grid.R
\name{igrf_grid}
\alias{igrf_grid}
\title{Generate an IGRF regular grid}
\usage{
igrf_grid(field = "main", year, type = "spheroid", altitude, resolution = 5)
}
\arguments{
\item{field}{main field (default = "main") or secular variation
("variation") data output}

\item{year}{year A.D. Must be greater than or equal to 1900.0 and
less than or equal to 2030. Warning message is given for dates
greater than 2025.}

\item{type}{"spheroid" (default) or "sphere" representation}

\item{altitude}{in km above the earth surface for a geodetic type,
or distance from the earth center for the spherical representation.}

\item{resolution}{spatial resolution of the output map in decimal degree
(default = 5).}
}
\value{
a data frame with components X,Y,Z,F, D, H and I for the main
geomagnetic field or the delta (dX etc) variants for the secular
variation on a regular grid. Data is returned in a tidy format with
required latitude and longitude columns for convenient plotting.
}
\description{
Generates a global grid (map) of the 13th Generation International
Geomagnetic Reference Field (IGRF) for a predefined spatial resolution
(in decimal degrees).
}
\examples{
grid <- igrf::igrf_grid(
year = 2000,
field = "main",
type = "spheroid",
altitude = 2,
resolution = 5
)
}
