% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{complementer}
\alias{complementer}
\title{Complementer of a graph}
\usage{
complementer(graph, loops = FALSE)
}
\arguments{
\item{graph}{The input graph, can be directed or undirected.}

\item{loops}{Logical constant, whether to generate loop edges.}
}
\value{
A new graph object.
}
\description{
A complementer graph contains all edges that were not present in the input
graph.
}
\details{
\code{complementer()} creates the complementer of a graph. Only edges
which are \emph{not} present in the original graph will be included in the
new graph.

\code{complementer()} keeps graph and vertex attriubutes, edge
attributes are lost.
}
\examples{

## Complementer of a ring
g <- make_ring(10)
complementer(g)

## A graph and its complementer give together the full graph
g <- make_ring(10)
gc <- complementer(g)
gu <- union(g, gc)
gu
graph.isomorphic(gu, make_full_graph(vcount(g)))

}
\seealso{
Other functions for manipulating graph structure: 
\code{\link{+.igraph}()},
\code{\link{add_edges}()},
\code{\link{add_vertices}()},
\code{\link{compose}()},
\code{\link{connect}()},
\code{\link{contract}()},
\code{\link{delete_edges}()},
\code{\link{delete_vertices}()},
\code{\link{difference}()},
\code{\link{difference.igraph}()},
\code{\link{disjoint_union}()},
\code{\link{edge}()},
\code{\link{igraph-minus}},
\code{\link{intersection}()},
\code{\link{intersection.igraph}()},
\code{\link{path}()},
\code{\link{permute}()},
\code{\link{rep.igraph}()},
\code{\link{reverse_edges}()},
\code{\link{simplify}()},
\code{\link{union}()},
\code{\link{union.igraph}()},
\code{\link{vertex}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{functions for manipulating graph structure}
\keyword{graphs}
