% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/iterators.R
\name{igraph-vs-indexing2}
\alias{[[.igraph.vs}
\alias{igraph-vs-indexing2}
\title{Select vertices and show their metadata}
\usage{
\method{[[}{igraph.vs}(x, ...)
}
\arguments{
\item{x}{A vertex sequence.}

\item{...}{Additional arguments, passed to \code{[}.}
}
\value{
The double bracket operator returns another vertex sequence,
  with meta-data (attribute) printing turned on. See details below.
}
\description{
The double bracket operator can be used on vertex sequences, to print
the meta-data (vertex attributes) of the vertices in the sequence.
}
\details{
Technically, when used with vertex sequences, the double bracket
operator does exactly the same as the single bracket operator,
but the resulting vertex sequence is printed differently: all
attributes of the vertices in the sequence are printed as well.

See \code{\link{[.igraph.vs}} for more about indexing vertex sequences.
}
\examples{
g <- make_ring(10) \%>\%
  set_vertex_attr("color", value = "red") \%>\%
  set_vertex_attr("name", value = LETTERS[1:10])
V(g)
V(g)[[]]
V(g)[1:5]
V(g)[[1:5]]
}
\seealso{
Other vertex and edge sequence operations: \code{\link{[.igraph.es}},
  \code{\link{\%--\%}}, \code{\link{\%->\%}},
  \code{\link{\%<-\%}}, \code{\link{igraph-es-indexing}};
  \code{\link{[.igraph.vs}},
  \code{\link{igraph-vs-indexing}};
  \code{\link{[[.igraph.es}},
  \code{\link{igraph-es-indexing2}};
  \code{\link{c.igraph.es}}; \code{\link{c.igraph.vs}};
  \code{\link{difference.igraph.es}};
  \code{\link{difference.igraph.vs}};
  \code{\link{intersection.igraph.es}};
  \code{\link{intersection.igraph.vs}};
  \code{\link{rev.igraph.es}}; \code{\link{rev.igraph.vs}};
  \code{\link{union.igraph.es}};
  \code{\link{union.igraph.vs}};
  \code{\link{unique.igraph.es}};
  \code{\link{unique.igraph.vs}}

Other vertex and edge sequences: \code{\link{$.igraph.es}},
  \code{\link{$<-.igraph.es}}, \code{\link{E<-}},
  \code{\link{[<-.igraph.es}},
  \code{\link{[[<-.igraph.es}},
  \code{\link{igraph-es-attributes}},
  \code{\link{igraph-es-attributes}},
  \code{\link{igraph-es-attributes}},
  \code{\link{igraph-es-attributes}},
  \code{\link{igraph-es-attributes}};
  \code{\link{$.igraph.vs}}, \code{\link{$<-.igraph.vs}},
  \code{\link{V<-}}, \code{\link{[<-.igraph.vs}},
  \code{\link{[[<-.igraph.vs}},
  \code{\link{igraph-vs-attributes}},
  \code{\link{igraph-vs-attributes}},
  \code{\link{igraph-vs-attributes}},
  \code{\link{igraph-vs-attributes}},
  \code{\link{igraph-vs-attributes}}; \code{\link{E}};
  \code{\link{V}}; \code{\link{[.igraph.es}},
  \code{\link{\%--\%}}, \code{\link{\%->\%}},
  \code{\link{\%<-\%}}, \code{\link{igraph-es-indexing}};
  \code{\link{[.igraph.vs}},
  \code{\link{igraph-vs-indexing}};
  \code{\link{[[.igraph.es}},
  \code{\link{igraph-es-indexing2}};
  \code{\link{print.igraph.es}};
  \code{\link{print.igraph.vs}}
}

