% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/active_percent.R
\name{active_percent}
\alias{active_percent}
\title{Calculate percentage of time CGM was active}
\usage{
active_percent(data, dt0 = NULL, tz = "",
range_type = "automatic", ndays = 14, end_date = NULL)
}
\arguments{
\item{data}{DataFrame object with column names "id", "time", and "gl".}

\item{dt0}{The time frequency for interpolated aligned grid in minutes, the default will match the CGM meter's frequency (e.g. 5 min for Dexcom).}

\item{tz}{\strong{tz = "".} A character string specifying the time zone to be used. System-specific (see \code{\link{as.POSIXct}}), but " " is the current time zone, and "GMT" is UTC (Universal Time, Coordinated). Invalid values are most commonly treated as UTC, on some platforms with a warning.}

\item{range_type}{\strong{range_type = "automatic".} A character string indicating the type of range ('automatic' or 'manual').}

\item{ndays}{\strong{ndays = 14.} An integer specifying the number of days to consider in the calculation.}

\item{end_date}{\strong{end_date = NULL.} A Date object or NULL indicating the end date for the calculation.}
}
\value{
A tibble object with five columns: subject id,
corresponding active_percent value, duration of measurement period in days, start date, and end date.
}
\description{
The function `active_percent` produces the % of time CGM is active together with the length of the measurement period
}
\details{
The function `active_percent` produces a tibble object with values equal to the
percentage of time the CGM was active, the total number of observed days, the start date, and the end date. For example, if a CGM's (5 min frequency) times were 0, 5, 10, 15 and
glucose values were missing at time 5, then percentage of time the CGM was active is 75%.
The output columns correspond to the subject id, the percentage of time for which the CGM was active, the number of days of measurements, the start date and the end date of measurements.
The output rows correspond to the subjects.
The values of `active_percent` are always between 0% (no measurements) and 100% (all measurements).
}
\examples{

data(example_data_1_subject)

active_percent(example_data_1_subject)

data(example_data_5_subject)

active_percent(example_data_5_subject)
active_percent(example_data_5_subject, dt0 = 5, tz = 'GMT')

}
\references{
Danne et al. (2017) International Consensus on Use of
Continuous Glucose Monitoring
\emph{Diabetes Care} \strong{40} .1631-1640,
\doi{10.2337/dc17-1600}.
}
\author{
Pratik Patel, Irina Gaynanova
}
