% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agp_metrics.R
\name{agp_metrics}
\alias{agp_metrics}
\title{Calculate metrics for the Ambulatory Glucose Profile (AGP)}
\usage{
agp_metrics(data, shinyformat = FALSE)
}
\arguments{
\item{data}{DataFrame object with column names "id", "time", and "gl".}

\item{shinyformat}{Logical indicating whether the output should be formatted for the single subject
AGP page in shiny. Defaults to FALSE.}
}
\value{
By default, a tibble object with 1 row for each subject, and 13 columns is returned:
a column for subject id,
a column for start date,
a column for end date,
a column for number of days,
a column for active_percent,
a column for Mean value,
a column for gmi value,
a column for cv value,
a column for below_54 value,
a column for below_70 value,
a column for in_range_70_180 value,
a column for above_180 value,
a column for above_250 value,
}
\description{
The function agp_metrics runs the following functions
and combines them into a tibble object: active_percent, mean_glu, gmi,
cv_glu, below_percent, in_range_percent, above_percent.
}
\details{
The function uses recommended cutoffs of 54, 70, 180, and 250 mg/dL for calculation.

If shinyformat = FALSE (default), returns a tibble object with 1 row for each subject, and 12 columns:
a column for subject id,
a column for start date,
a column for end date,
a column for number of days,
a column for active_percent,
a column for Mean value,
a column for gmi value,
a column for cv value,
a column for below_54 value,
a column for below_70 value,
a column for in_range_70_180 value,
a column for above_180 value,
a column for above_250 value.
If shinyformat = TRUE, a tibble with 2 columns: metric and value, is returned.
This output is used when generating the single subject AGP shiny page.
}
\examples{
data(example_data_1_subject)
agp_metrics(example_data_1_subject)

}
\references{
Johnson et al. (2019) Utilizing the Ambulatory Glucose Profile to Standardize and
Implement Continuous Glucose Monitoring in Clinical Practice,
\emph{Diabetes Technology and Therapeutics} \strong{21:S2} S2-17-S2-25,
\doi{10.1089/dia.2019.0034}.
}
