% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cosd.R
\encoding{UTF-8}
\name{sind}
\alias{sind}
\title{Sine (in degrees) [GNU Octave/MATLAB compatible]}
\usage{
sind(x)
}
\arguments{
\item{x}{A numeric vector containing values in degrees}
}
\value{
The sine of each element of \code{x} in degrees. Zero for any
"elements where \code{x} / 180 is an integer."
}
\description{
Calculates the value of sine for each element of \code{x} in degrees in a
manner compatible with GNU Octave/MATLAB. Zero is returned for any "elements
where \code{x} / 180 is an integer." Reference: Eaton.
}
\note{
Note: If you have a radian (rad) angle value, use \code{\link[base]{sin}} instead.
}
\examples{

library(iemisc)

# Examples from GNU Octave sind
sind(seq(10, 90, by = 10))

sind(c(0, 180, 360))

sind(c(90, 270))


}
\references{
John W. Eaton, David Bateman, Søren Hauberg, and Rik Wehbring (November 2022). \emph{GNU Octave: A high-level interactive language for numerical computations: Edition 7 for Octave version 7.3.0}. \url{https://docs.octave.org/octave.pdf}. Page 553.
}
\author{
David Bateman (GNU Octave sind), Irucka Embry
}
