% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitcomma.R
\encoding{UTF-8}
\name{\%inorder\%}
\alias{\%inorder\%}
\title{IN ORDER for Character and Numeric Vectors}
\source{
R - preserve order when using matching operators (%in%) - Stack Overflow answered by John Wallace on Nov 3, 2017. See \url{https://stackoverflow.com/questions/10586652/r-preserve-order-when-using-matching-operators-in}.
}
\usage{
y \%inorder\% table
}
\arguments{
\item{y}{numeric vector that contains the sequence to return}

\item{table}{character vector, data.table, and/or tibble that has the
character values to be checked within}
}
\value{
character vector with the characters in the original sequence
}
\description{
This function preserves the original order (sequence) of character vectors.
}
\examples{

# Examples (from the Source)

LETTERS[1:26 \%in\% 4:1]

LETTERS[1:26 \%inorder\% 4:1]



LETTERS[1:26 \%in\% 3:-5]

LETTERS[1:26 \%inorder\% 3:-5]


data.frame(letters, LETTERS)[1:5 \%in\% 3:-5, ] 

data.frame(letters, LETTERS)[1:5 \%inorder\% 3:-5, ]


library(data.table)

data.table(letters, LETTERS)[1:5 \%inorder\% 3:-5, ] 


library(tibble)

tibble(letters, LETTERS)[1:5 \%inorder\% 3:-5, ]





}
\author{
John Wallace (Stack Overflow R code), Irucka Embry
}
