% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitcomma.R
\encoding{UTF-8}
\name{\%notchin\%}
\alias{\%notchin\%}
\title{Not CHIN or IN for Character and Numeric Vectors}
\source{
The %notin% operator Posted on July 8, 2018 by kaijagahm in R bloggers. See \url{https://www.r-bloggers.com/2018/07/the-notin-operator/}.
}
\usage{
x \%notchin\% y
}
\arguments{
\item{x}{character or numeric vector that contains the values to not be matched}

\item{y}{character or numeric vector that has the values to be checked within}
}
\value{
logical vector the length of the original string (x). TRUE means that
   x is not in y and FALSE means that x is in y
}
\description{
This function performs a quick, case sensitive search of character vectors
that are not in a set of character vectors or a quick, search of numeric
vectors that are not in a set of numeric vectors using \code{\link[base]{Negate}} chin
for character vectors and \code{\link[base]{Negate}} \code{\link[base]{in}} for numeric vectors
}
\details{
'Utilizes chin from data.table to quickly complete a case
   insensitive search through a character vector to return a logical vector
   of string detections. Will always return TRUE or FALSE for each position
   of string regardless of NA missing values in either provided vector. NA
   in string will never match an NA value in the vector.'
}
\examples{

# Examples

x <- c("apple", "banana", "cherry", NA)

"apple" \%notchin\% x

c("apple", "BANANA", "coconut", NA) \%notchin\% x

x


"a" \%notchin\% letters[5:20]
letters[5:20] \%notchin\% "a"


"a" \%notchin\% LETTERS
LETTERS \%notchin\% "a"


1 \%notchin\% -12:20
-12:20 \%notchin\% 1




}
\author{
kaijagahm (R code), Irucka Embry
}
