% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igivenPFn.R
\encoding{UTF-8}
\name{igivenICPn}
\alias{igivenICPn}
\title{Simple Interest rate given Interest Charged, Number of years, and Principal value}
\usage{
igivenICPn(P, IC, n = NULL, begin_event = NULL, end_event = NULL)
}
\arguments{
\item{P}{numeric vector that contains the principal value}

\item{IC}{numeric vector that contains the total amount of interest charged}

\item{n}{numeric vector that contains the number of years}

\item{begin_event}{character vector that contains the start date}

\item{end_event}{character vector that contains the end date}
}
\value{
i numeric vector that contains the simple interest rate as a
percent rounded to 2 decimal places
}
\description{
Compute i given IC, n, and P
}
\details{
i is expressed as

	\deqn{i = {\frac{IC * 100}{P * n}}}

\describe{
\item{\emph{i}}{the interest rate}
\item{\emph{IC}}{the total amount of interest charged}
\item{\emph{P}}{the principal amount of the loan}
\item{\emph{n}}{the number of years}
}
}
\examples{

# Example 1

library("iemisc")

igivenICPn(P = 500, IC = 1000, n = 10)




# Example 2

library("iemisc")

igivenICPn(P = 500, IC = 1000, begin_event = "1 January 2020", end_event = "1 January 2030")


}
\references{
TN Code § 47-14-102 (2021). 2021 Tennessee Code -- Title 47 - Commercial Instruments and Transactions -- Chapter 14 - Interest Rates Generally -- § 47-14-102. Definitions. See \url{https://law.justia.com/codes/tennessee/2021/title-47/chapter-14/section-47-14-102/}.
}
\author{
Irucka Embry
}
