% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Re.R
\encoding{UTF-8}
\name{Re1}
\alias{Re1}
\title{Calculating the Reynolds Number 1}
\usage{
Re1(D, V, rho, mu, gc = NULL, units = c("SI", "Eng", "slug"))
}
\arguments{
\item{D}{numeric vector that contains the hydraulic diameters '(four times
the area in flow divided by the wetted surface) is a characteristic
length' (m or ft) {Reference: Lindeburg Manual}}

\item{V}{numeric vector that contains the average fluid velocity (m/s or
ft/s) {Reference: Lindeburg Manual}}

\item{rho}{numeric vector that contains the fluid density (kg/m^3 or
lbm/ft^3) {Reference: Lindeburg Manual}}

\item{mu}{numeric vector that contains the absolute or dynamic viscosity of
the fluid (Pa-s or lbf-sec/ft^2) {Reference: Lindeburg Manual}}

\item{gc}{numeric vector that contains the gravitational constant (32.2
lbm-ft/lbf-sec^2) {Reference: Lindeburg Manual}}

\item{units}{character vector that contains the system of units {options are
\code{SI} for International System of Units, \code{Eng} for English units
(United States Customary System in the United States and Imperial Units in
the United Kingdom), and \code{slug} for the English unit slug which is a
consistent unit of mass}}
}
\value{
the Reynolds number as a \code{\link{list}} for Re1
}
\description{
Various Methods of Calculating the Reynolds number
}
\details{
The Reynolds number, named after Osborne Reynolds, is a dimensionless number
that is used to determine the type of fluid flow (laminar, transition, or
turbulent). {References: Lindeburg Manual and Subramanian}


Re1 - uses the absolute or dynamic viscosity (\\mu)
Re2 and Re4 - use kinematic viscosity (\\nu)
Re3 - uses the 'mass flow rate per unit area' (G) {Reference: Lindeburg Manual}



The Reynolds number equation can be expressed in the following ways
(Reference: Lindeburg Manual):

\deqn{Re = \frac{inertial_forces}{viscous_forces}}



\deqn{Re = \frac{DV\\rho}{\\mu}}

\describe{
  \item{\emph{Re}}{the Reynolds number (dimensionless)}
  \item{\emph{D}}{the hydraulic diameters (m)}
  \item{\emph{V}}{average velocity of the fluid (m/s)}
  \item{\emph{\\rho}}{density of the fluid at a certain temperature (kg/m^3)}
  \item{\emph{\\mu}}{absolute or dynamic viscosity of the fluid at a certain temperature (Pa-s)}
}



\deqn{Re = \frac{DV\\rho}{\\mug_c}}

\describe{
  \item{\emph{Re}}{the Reynolds number (dimensionless)}
  \item{\emph{D}}{the hydraulic diameters (ft)}
  \item{\emph{V}}{average velocity of the fluid (ft/sec)}
  \item{\emph{\\rho}}{density of the fluid at a certain temperature (lbm/ft^3)}
  \item{\emph{\\mu}}{absolute or dynamic viscosity of the fluid at a certain temperature (lbf-sec/ft^2)}
  \item{\emph{g_c}}{gravitational constant (32.2 lbm-ft/lbf-sec^2) used for dimensional analysis so that the Reynolds number will be dimensionless with US Customary units}
}



\deqn{Re = \frac{DG}{\\mu}}

\describe{
  \item{\emph{Re}}{the Reynolds number (dimensionless)}
  \item{\emph{D}}{the hydraulic diameters (m)}
  \item{\emph{G}}{'mass flow rate per unit area' (kg/m^2-s)}
  \item{\emph{\\mu}}{absolute or dynamic viscosity of the fluid at a certain temperature (Pa-s)}
}



\deqn{Re = \frac{DG}{g_c\\mu}}

\describe{
  \item{\emph{Re}}{the Reynolds number (dimensionless)}
  \item{\emph{D}}{the hydraulic diameters (ft)}
  \item{\emph{G}}{'mass flow rate per unit area' (lbm/ft^2-sec)}
  \item{\emph{\\mu}}{absolute or dynamic viscosity of the fluid at a certain temperature (lbf-sec/ft^2)}
  \item{\emph{g_c}}{gravitational constant (32.2 lbm-ft/lbf-sec^2) used for dimensional analysis so that the Reynolds number will be dimensionless with US Customary units}
}


where
\deqn{G = {\\rhoV}}

\describe{
  \item{\emph{G}}{'mass flow rate per unit area' (kg/m^2-s)}
  \item{\emph{\\rho}}{density of the fluid at a certain temperature (kg/m^3)}
  \item{\emph{V}}{average velocity of the fluid (m/s)}
}



\deqn{Re = \frac{DV}{\\nu}}

\describe{
  \item{\emph{Re}}{the Reynolds number (dimensionless)}
  \item{\emph{D}}{the hydraulic diameters (m)}
  \item{\emph{V}}{average velocity of the fluid (m/s)}
  \item{\emph{\\nu}}{kinematic viscosity of the fluid at a certain temperature (m^2/s)}
}



\deqn{Re = \frac{DV}{\\nug_c}}

\describe{
  \item{\emph{Re}}{the Reynolds number (dimensionless)}
  \item{\emph{D}}{the hydraulic diameters (ft)}
  \item{\emph{V}}{average velocity of the fluid (ft/sec)}
  \item{\emph{\\nu}}{absolute or dynamic viscosity of the fluid at a certain temperature (lbf-sec/ft^2)}
  \item{\emph{g_c}}{gravitational constant (32.2 lbm-ft/lbf-sec^2) used for dimensional analysis so that the Reynolds number will be dimensionless with US Customary units}
}


where
\deqn{\\nu = \frac{\\mu}{\\rho}}

\describe{
  \item{\emph{\\nu}}{kinematic viscosity of the fluid at a certain temperature (m^2/s)}
  \item{\emph{\\mu}}{absolute or dynamic viscosity of the fluid at a certain temperature (Pa-s)}
  \item{\emph{\\rho}}{density of the fluid at a certain temperature (kg/m^3)}
}


where
\deqn{\\nu = \frac{\\mug_c}{\\rho}}

\describe{
  \item{\emph{\\nu}}{kinematic viscosity of the fluid at a certain temperature (ft^2/sec)}
  \item{\emph{\\mu}}{absolute or dynamic viscosity of the fluid at a certain temperature (lbf-sec/ft^2)}
  \item{\emph{g_c}}{gravitational constant (32.2 lbm-ft/lbf-sec^2) used for dimensional analysis so that the kinematic viscosity units will work in US Customary units}
  \item{\emph{\\rho}}{density of the fluid at a certain temperature (lbm/ft^3)}
}
}
\note{
Please Note: The conventional wisdom that a Reynolds number less than 2100
is laminar flow, between 2100 and 4000 is transitional or critical flow, and
greater than 4000 is turbulent flow is not accurate. 'Reynolds himself
observed that turbulence was triggered by inlet disturbances to the pipe and
the laminar state could be maintained to Re \\u2248 12,000 if he took great care
in minimizing external disturbances to the flow. By careful design of pipe
entrances Ekman (1910) has maintained laminar pipe flow up to a Reynolds
number of 40,000 and Pfenniger (1961) up to 100,000 by minimising ambient
disturbances.' {References: Lindeburg Manual and Trinh}

'Numerous experiments have shown that the flow in a pipe changes from
laminar to turbulent in the range of R between the critical value of 2,000
and a value that may be as high as 50,000.* In these experiments the
diameters of the pipe was taken as the characteristic length in defining the
Reynolds number. When the hydraulic radius is taken as the characteristic
length, the corresponding range is from 500 to 12,500,* since the diameters
of a pipe is four times its hydraulic radius. * = It should be noted that
there is actually no definite upper limit.' {Reference: Chow}

Note: Units must be consistent
}
\examples{

# from Lindeburg Reference page 17-8
# D = 0.3355 ft
# V = 7.56 ft/sec

# from the Chow reference, water at 68 F (20 C) has the following properties

library("iemisc")

# mu (dynamic viscosity) = 2.09 * 10 ^ -5 slug/ft-sec
# rho (density) = 1.937 slug/ft^3
# v (kinematic viscosity) = mu / rho = 1.08 * 10 ^ -5

Re1(D = 0.3355, V = 7.56, rho = 1.937, mu = 2.09 * 10 ^ -5, units = "slug")




}
\references{
\enumerate{
   \item Ven Te Chow, Ph.D., \emph{Open-Channel Hydraulics}, McGraw-Hill Classic Textbook Reissue, New York City, New York: McGraw-Hill Book Company, 1988, pages 7-8.
   \item Michael R. Lindeburg, PE, \emph{Civil Engineering Reference Manual for the PE Exam}, Twelfth Edition, Belmont, California: Professional Publications, Inc., 2011, pages 17-1, 17-5, 17-8 - 17-9.
   \item The NIST Reference on Constants, Units, and Uncertainty, Fundamental Constants Data Center of the NIST Physical Measurement Laboratory, "standard acceleration of gravity g_n", \url{https://physics.nist.gov/cgi-bin/cuu/Value?gn}.
   \item R. Shankar Subramanian, "Pipe Flow Calculations", page 9, Clarkson University Department of Chemical and Biomolecular Engineering, \url{https://web2.clarkson.edu/projects/subramanian/ch330/notes/Pipe\%20Flow\%20Calculations.pdf}.
   \item R. Shankar Subramanian, "Reynolds Number", page 1, Clarkson University Department of Chemical and Biomolecular Engineering, \url{https://web2.clarkson.edu/projects/subramanian/ch330/notes/Reynolds\%20Number.pdf}.
   \item Khanh Tuoc Trinh, "On the Critical Reynolds Number for Transition From Laminar to Turbulent Flow", page 2, \url{https://arxiv.org/abs/1007.0810}.
   \item Wikimedia Foundation, Inc. Wikipedia, 15 May 2019, "Conversion of units", \url{https://en.wikipedia.org/wiki/Conversion_of_units}.
}
}
\seealso{
\code{\link{f1}}, \code{\link{f2}}, \code{\link{f3}}, \code{\link{f4}}, \code{\link{f5}}, \code{\link{f6}}, \code{\link{f7}}, and \code{\link{f8}}
for the Darcy friction factor (f) for pipes

\code{\link{Re2}}, \code{\link{Re3}}, \code{\link{Re4}}
}
\author{
Irucka Embry
}
