% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qw.R
\encoding{UTF-8}
\name{qw}
\alias{qw}
\alias{qwBATCH}
\alias{qw2}
\title{qw, qw2 and qwBATCH}
\source{
\enumerate{
   \item r - How can I check if a file is empty? - Stack Overflow answered by Konrad Rudolph and edited by Geekuna Matata on Apr 23 2014. See \url{https://stackoverflow.com/questions/23254002/how-can-i-check-if-a-file-is-empty}.
   \item r - Better error message for stopifnot? - Stack Overflow answered by Andrie on Dec 1 2011. See \url{https://stackoverflow.com/questions/8343509/better-error-message-for-stopifnot}.
   \item RDocumentation: TclInterface {tcltk}. See \url{https://www.rdocumentation.org/packages/tcltk/versions/3.3.1}.
   \item James Wettenhall & Philippe Grosjean, File Open/Save dialogs in R tcltk, December 01, 2015. See \url{https://web.archive.org/web/20160521051207/http://www.sciviews.org/recipes/tcltk/TclTk-file-open-save-dialogs/}. Retrieved thanks to the Internet Archive: Wayback Machine
   \item r - read csv files and perform function, then bind together - Stack Overflow answered by bjoseph on Jan 8 2015. See \url{https://stackoverflow.com/questions/27846715/read-csv-files-and-perform-function-then-bind-together}.
   \item r - Convert column classes in data.table - Stack Overflow answered by Matt Dowle on Dec 27 2013. See \url{https://stackoverflow.com/questions/7813578/convert-column-classes-in-data-table}.
   \item Does column exist and how to rearrange columns in R data frame - Stack Overflow answered and edited by Peter McMahan on Aug 2 2009. See \url{https://stackoverflow.com/questions/1177919/does-column-exist-and-how-to-rearrange-columns-in-r-data-frame}.
   \item time - Dealing with timestamps in R - Stack Overflow answered by Dirk Eddelbuettel on Dec 26 2009. See \url{https://stackoverflow.com/questions/1962278/dealing-with-timestamps-in-r/1962336}.
   \item R help - How to change the default Date format for write.csv function? answered by William Dunlap on Dec 28, 2009. See \url{https://hypatia.math.ethz.ch/pipermail/r-help/2009-December/416010.html}.
   \item RDocumentation: strptime {base}. See \url{https://www.rdocumentation.org/packages/base/versions/3.3.1/topics/strptime}.
   \item National Water Information System: Help System Time Zone Codes. See \url{https://help.waterdata.usgs.gov/code/tz_query?fmt=html}.
   \item multiple output filenames in R - Stack Overflow asked and edited by Gabelins on Feb 1 2013. See \url{https://stackoverflow.com/questions/14651594/multiple-output-filenames-in-r}.
   \item r - Regex return file name, remove path and file extension - Stack Overflow answered and edited by Ananda Mahto on Feb 25 2013. See \url{https://stackoverflow.com/questions/15073753/regex-return-file-name-remove-path-and-file-extension/15073919}.
   \item warnings - How do I get rid of the NOTE's generated by R CMD check when using for example ddply in my package? - Stack Overflow answered by shadow on Mar 4 2015 and edited by shadow on Mar 5 2015. See \url{https://stackoverflow.com/questions/28851812/how-do-i-get-rid-of-the-notes-generated-by-r-cmd-check-when-using-for-example-d}.
   \item trinker/qdapRegex - dictionary_maintenance.R. See \url{https://github.com/trinker/qdapRegex/blob/master/inst/dictionary_maintenance.R}.
   \item excel - Interconverting POSIXct and numeric in R - Stack Overflow by LauraS on May 6 2016. See \url{https://stackoverflow.com/questions/37078772/interconverting-posixct-and-numeric-in-r}.
   \item convert date and time string to POSIX in R - Stack Overflow commented by cryo111 on Sep 18 2013. See \url{https://stackoverflow.com/questions/18874400/convert-date-and-time-string-to-posix-in-r/18874863}.
}
}
\usage{
qw(
  file = tk_choose.files(default = "", caption =
    "Select file(s) to open & hold down Ctrl to choose more than 1 file", multi = TRUE,
    filters = matrix(c("QW file", "*", "QW file", ".rdb", "QW file", ".RDB"), 6, 2, byrow
    = TRUE)),
  interactive = TRUE,
  overwrite = TRUE
)

qwBATCH(
  path = tk_choose.dir(caption = "Select directory with the QW files"),
  pattern = "*.rdb",
  overwrite = TRUE
)

qw2(file, overwrite = TRUE)
}
\arguments{
\item{file}{Input QW file(s) to be selected through a file dialog.}

\item{interactive}{If interactive is \code{TRUE}, then the user will select the
filenames(s) to use for saving with the file dialog. In order to select
more than one file, the user must hold down the Ctrl (Control) button
while mouse clicking the chosen files. If interactive is \code{FALSE}, then
the user will select the directory, via the directory dialog, to use for
saving and the original filenames will be used.}

\item{overwrite}{If \code{TRUE}, overwrite any existing spreadsheet.}

\item{path}{Directory path of QW files to be selected through a directory
dialog. The user will be asked where to find the QW files & then the
user will be asked where to save the QW .xlsx files.}

\item{pattern}{The default pattern is \code{.rdb} (the filename has the .rdb
extension). This pattern can be changed by \code{qwBATCH(pattern = "pattern")}.}
}
\value{
QW .xlsx file(s).
}
\description{
qw, qw2 and qwBATCH process raw QW files. The QW files can contain "selected
  water-quality data for stations in the U.S. Geological Survey (USGS)
  National Water Information System (NWIS) water-quality database. The data
  you have secured from the USGS NWISWeb database may include data that have
  not received Director's approval and as such are provisional and subject
  to revision."
}
\details{
qw function opens a single or multiple raw, QW file(s) to modify the format
  and then exports the file(s) in .xlsx format. This is done for a single
  file or multiple files that the user selects with a file dialog.

qw2 function opens a single QW file to modify the format and then exports
  the file in .xlsx format. This is done for a single file that the user
  selects without a file dialog.

qwBATCH function opens raw QW files, from a directory, to modify the format
  and then exports the files in .xlsx format.  This is done in a BATCH mode
  (whole directory of QW files) using a directory dialog.

qw, qw2 and qwBATCH functions perform the same processes on the raw QW
  files: 1) remove the first row, 2) create a single column with the Date
  and Time rather than 2 separate Date and Time columns (if needed), and 3)
  exports the QW file as a spreadsheet with three sheets (sheet1 corrects
  the timezones for Daylight Savings Times, sheet2 includes everything
  except for the meta data, and sheet3 provides the meta data from the top
  of the file). The supported US timezones are the following: Eastern,
  Central, Mountain, Pacific, Alaska, Hawai'i, and Atlantic (Puerto Rico
  and US Virgin Islands).
}
\examples{
\donttest{
library("ie2misc")
# Examples to change (an) QW file(s) interactively and non-interactively
file1 <- "https://waterdata.usgs.gov/nwis/dv?cb_00060=on&format=rdb&site_no=03584500"
file2 <- "&period=&begin_date=1904-07-01&end_date=2016-06-22"
file3 <- paste0(file1, file2) # used to truncate the file name
qw2(file3)
# USGS 03584500 ELK RIVER NEAR PROSPECT, TN
# Discharge, cubic feet per second (Mean)



qw() # default where interactive = TRUE
# Follow the file dialog instructions


qw(interactive = FALSE)
# Follow the file dialog instructions


# Example to change QW files in batch mode
qwBATCH()
# Follow the file dialog instructions
}



}
