% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_parameter_permutations.R
\name{generate_parameter_permutations}
\alias{generate_parameter_permutations}
\title{A Function to Generate Parameter Permutations}
\usage{
generate_parameter_permutations(
  variable_params = NULL,
  fixed_params = NULL,
  sample_params = NULL,
  excluded_params = NULL,
  scenarios = NULL,
  sampling_function = NULL,
  parameter_samples = 1,
  repeat_sample = TRUE,
  rerun = FALSE,
  ...
)
}
\arguments{
\item{variable_params}{A dataframe containing any parameter variations to be investigated. If
these parameters would normally be sampled then they should be added to the excluded_params argument.}

\item{fixed_params}{A named vector of parameters that are not sampled by the sampling function. If
these parameters would usually be sampled then they should be added to the excluded_params argument.}

\item{sample_params}{A named vector of parameters to be sampled. If a sampling function is not supplied these
parameters will be used in the final permutation dataframe.}

\item{excluded_params}{A character vector indicating which parameters should have there sampled values
kept.}

\item{scenarios}{A dataframe of possible scenarios to investigate. It must contain a scenario variable to
identify each separate scenarios. If parameters are included here that would normally be sampled then they
should be added to the excluded_params argument}

\item{sampling_function}{A sampling function, this should be designed such that it's input is a matrix
with each parameter having a named row. It should return it's output in the same format. If not supplied
defaults to passing
through parameters, this may not be the required behaviour.}

\item{parameter_samples}{The number of parameter samples to take, defaults to one.}

\item{repeat_sample}{A logical (defaults to \code{TRUE}) which indicates if each scenario should independently
sample from the sampling function. If set to \code{FALSE} then each scenario will share the same sampled
parameter set.}

\item{rerun}{A logical indicating if the function should be rerun or saved results should be loaded.
Defaults to \code{FALSE}.}

\item{...}{Additional arguments to be passed to the sampling_function.}
}
\value{
A dataframe containing sampled parameter permutations
}
\description{
A function to generate parameter permutations from a generic sampling function (or if not given
from the input parameters). This function can be used to rapidly generate new parameter combinations given
parameters to be varied, and scenarios to be investigated.
}
\examples{

scenarios <- data.frame(scenario = c("test_1", "test_2"), scenario_param = c(0, 1))
variable_params <-  data.frame(variable = c(0, 0.5, 1))
fixed_params <- c(fixed_1 = 2, fixed_2 = c(1, 3, 4))
sample_params <- c(sample_1 = 2, sample_2 = c(2, 1))

generate_parameter_permutations(variable_params, fixed_params, sample_params,
                                excluded_params = c("variable"), scenarios,
                                parameter_samples = 1)
}
