% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idem_analysis.R
\name{imEstimate}
\alias{imEstimate}
\title{Treatment effect estimation}
\usage{
imEstimate(imp.rst, offset = 10000, quantiles = 0.5, ...)
}
\arguments{
\item{imp.rst}{A class \code{IDEM.IMP} list containing complete data
with relevant missing values imputed. See \code{\link{imImpAll}}.}

\item{offset}{A constant value to be added to survival days for reporting the
median value}

\item{quantiles}{Quantiles of the composite endpoint to be reported}

\item{...}{Options for ranking subjects using the composite endpoint
\describe{
\item{cut.z}{Clinically meaningful difference in the functional outcome}
\item{cut.surv}{Clinically meaningful difference in survival time}}}
}
\value{
A class \code{IDEM.RST} list contains
\describe{
\item{list.var}{List of parameters}
\item{theta}{A dataset with columns \code{Delta0}, \code{Delta1}, \eqn{\hat{\theta}}}
\item{quantiles}{ A dataset with columns \code{Delta}, \code{Trt}, \code{Quantiles}}
\item{survivor}{A dataset for survivors with columns \code{Delta0}, \code{Delta1}, \code{Mean0},
\code{Mean1}, \code{Diff}}}
}
\description{
Estimate treatment effect and median of the composite endpoint from using
imputed data
}
\examples{
\dontrun{
lst.var <- list(trt="TRT", surv="SURV", outcome=c("Y1","Y2"), y0=NULL,
                endp=c("Y2"), unitTime="days",
                trt.label = c("UC+SBT", "SAT+SBT"),
                cov=c("AGE"), endfml="Y2", duration=365, bounds=c(0,100));
rst.fit <- imFit(abc, lst.var);
rst.imp <- imImpAll(abc, rst.fit, lst.var, deltas=c(-0.25,0,0.25),
                    normal=TRUE, iter=300, n.imp=2, thin=10, p.scale=10);
rst.est <- imEstimate(rst.imp, quantiles=c(0.25,0.5,0.75));}

}
