% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/launch_app.R
\name{launch_app}
\alias{launch_app}
\title{Launch the IDC NRBA application}
\usage{
launch_app(maxRequestSize = 50, debug = FALSE, shiny.server = FALSE)
}
\arguments{
\item{maxRequestSize}{Number defining the maximum allowed filesize (in megabytes)
for uploaded files, defaults to 50MB}

\item{debug}{Logical value. If \code{debug = TRUE},
then tracing output will be displayed in the R console
so that the user can see the values being passed
between the R session running the application
and the browser displaying the application.}

\item{shiny.server}{Setting this parameter to \code{TRUE} will return the app in the form of an
object rather than invoking it. This is useful for deploying this app via \code{shiny-server}.}
}
\value{
Launches an interactive Shiny app; the function does not return a value.
}
\description{
Launches an interactive application
for conducting nonresponse bias analysis.
}
\details{
The application is a graphical user interface
developed using the \emph{shiny} and \emph{rmarkdown} frameworks.
This application requires Pandoc to be installed.
If the application is run from within RStudio,
then Pandoc should automatically be available,
as Pandoc is bundled with RStudio installations.
}
\examples{
if (interactive()) {
  launch_app()
}
}
