% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survplot.R
\name{survplot}
\alias{survplot}
\title{'Plotting individual survival curves'}
\usage{
survplot(x, i, smooth = TRUE, timepoints = NULL,
  title = "Estimated survival curve", suppress.inf.time = TRUE, ...)
}
\arguments{
\item{x}{an object of class \code{icrf} or a survival matrix with rows
representing subjects and columns representing times}

\item{i}{subject index}

\item{smooth}{which curve of an \code{icrf} object to be plotted? smoothed or non-smoothed.
Ignored when \code{x} is a matrix.}

\item{timepoints}{A numeric vector. needed when the time attribute is missing.}

\item{title}{Title of the plot.}

\item{suppress.inf.time}{Do not draw the curve at \code{timepoints} being infinity?}

\item{...}{'Other graphical parameters to be passed on to' \code{ggplot}.}
}
\value{
'Invisibly,' the vector of survival probabilities that are plotted.
}
\description{
Plotting individual survival curves.
}
\examples{
# rats data example.
# Note that this is a toy example. Use a larger ntree and nfold in practice.
data(rat2)
\donttest{
 set.seed(1)
 rats.icrf <-
   icrf(~ dose.lvl + weight + male + cage.no, data = rat2,
        data.type = "currentstatus", currentstatus.label = c("survtime", "tumor"),
        returnBest = TRUE, ntree=10, nfold=3)
 survplot(rats.icrf, c(1,3,5))
}
\dontshow{
 set.seed(1)
 rats.icrf <-
   icrf(~ dose.lvl + weight + male + cage.no, data = rat2,
        data.type = "currentstatus", currentstatus.label = c("survtime", "tumor"),
        returnBest = TRUE, ntree=2, nfold=2)
 survplot(rats.icrf, c(1,3,5))
}

}
\references{
\href{https://arxiv.org/abs/1912.09983}{Cho H., Jewell N. J., and Kosorok M. R. (2020+). "Interval censored
 recursive forests"}
}
\author{
Hunyong Cho, Nicholas P. Jewell, and Michael R. Kosorok.
}
