% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.icrf.R
\name{plot}
\alias{plot}
\alias{plot.icrf}
\title{icrf IMSE rate plot}
\usage{
\method{plot}{icrf}(x, type = "l", main = deparse(substitute(x)),
  oob = FALSE, ...)
}
\arguments{
\item{x}{an object of \code{icrf} class.}

\item{type}{'type of plot.'}

\item{main}{'main title of the plot.'}

\item{oob}{Whether the out-of-bag error should be returned?}

\item{...}{'other graphical parameters.'}
}
\value{
The IMSE (integrated mean squared error) of the \code{icrf} object
is invisibly returned. 'If the object has a non-null test component, then the returned
object is a matrix where the first' (two) column is the IMSE measure (types 1 and 2), 'and
the second column is for the test set.'
The rows represent the forest iterations.
}
\description{
'Plot the error rates or MSE of a randomForest object'
(Quoted statements are from
\code{randomForest} by Liaw and Wiener unless otherwise mentioned.)
}
\note{
'If the \code{x} has a non-null \code{test} component, then the test set errors are
also plotted.'
}
\examples{
# rats data example
# Note that this is a toy example. Use a larger ntree and nfold in practice.
data(rat2)
set.seed(1)
samp <- sample(1:dim(rat2)[1], 200)
rats.train <- rat2[samp, ]
rats.test <- rat2[-samp, ]
L = ifelse(rats.train$tumor, 0, rats.train$survtime)
R = ifelse(rats.train$tumor, rats.train$survtime, Inf)
# Note that this is a toy example. Use a larger ntree and nfold in practice.
set.seed(2)
\dontshow{
# 1. formula (currentstatus)
 rats.icrf.small <-
   icrf(~ dose.lvl + weight + male + cage.no, data = rat2,
        data.type = "currentstatus", currentstatus.label = c("survtime", "tumor"),
        returnBest = TRUE, ntree=2, nfold=1)
 plot(rats.icrf.small)
}
\donttest{
 rats.icrf.small <-
   icrf(~ dose.lvl + weight + male + cage.no, data = rat2,
        data.type = "currentstatus", currentstatus.label = c("survtime", "tumor"),
        returnBest = TRUE, ntree=10, nfold=3)
 plot(rats.icrf.small)
}
}
\references{
\href{https://arxiv.org/abs/1912.09983}{Cho H., Jewell N. J., and Kosorok M. R. (2020+). "Interval censored
 recursive forests"}
}
\author{
Hunyong Cho, Nicholas P. Jewell, and Michael R. Kosorok.
}
