% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oanda.R
\name{oanda_positions}
\alias{oanda_positions}
\title{OANDA Position Book}
\usage{
oanda_positions(instrument, time, server, apikey)
}
\arguments{
\item{instrument}{string containing the base currency and quote currency
delimited by '_' or '-' (e.g. "USD_JPY" or "usd-jpy"). Use the
\code{\link{oanda_instruments}} function to return a list of all valid
instruments.}

\item{time}{(optional) the time for which to retrieve the position book, in a
format convertible to POSIXct by \code{as.POSIXct()}. If not specified,
the most recent position book will be retrieved.}

\item{server}{(optional) specify the "practice" or "live" server according to
the account type held. If not specified, will default to "practice", unless
this has been changed by \code{\link{oanda_switch}}.}

\item{apikey}{(optional) string containing the OANDA fxTrade API key (personal
access token), or function that returns this string. Does not need to be
specified if already stored by oanda_set_key(). Can also be entered
interactively if not specified.}
}
\value{
Invisibly, a data frame of the position book with parameters saved as
    attributes. A chart showing the percentage long and short positions at
    each price level is output to the graphical device.
}
\description{
Provides a summary of the aggregate positions held by OANDA fxTrade clients
    at each price level.
}
\details{
This feature has been implemented by OANDA only for certain major
    currency pairs and should be considered experimental.

    For further details please refer to the OANDA fxTrade API vignette by
    calling: \code{vignette("xoanda", package = "ichimoku")}.
}
\examples{
\dontrun{
# OANDA fxTrade API key required to run this example
oanda_positions("USD_JPY")
}

}
