% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SAGxml.R
\name{convertSAGxml}
\alias{convertSAGxml}
\alias{createSAGxml}
\alias{readSAGxml}
\title{Create and read the SAG XML data transfer file}
\usage{
createSAGxml(info, fishdata)

readSAGxml(file)
}
\arguments{
\item{info}{a list of stock information}

\item{fishdata}{a data frame of fish data}

\item{file}{an xml file name}
}
\value{
Either a list containing info and fishdata, or a string containing the xml file.
}
\description{
Convert between R data (a list and a data.frame) and the XML format required for uploading
data to the SAG database.
}
\examples{

info <- stockInfo(StockCode = "cod.27.347d",
                  AssessmentYear = 2017,
                  StockCategory = 1,
                  ModelType = "A",
                  ModelName = "SCA",
                  ContactPerson = "itsme@fisheries.com")
fishdata <- stockFishdata(Year = 1990:2017, Catches = 100)
xmlfile <- createSAGxml(info, fishdata)

out <- readSAGxml(xmlfile)

}
\seealso{
\code{\link{stockInfo}} creates a list of stock information.

\code{\link{stockFishdata}} creates a data frame of fish stock summary data.
}
