% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSummaryTable.R
\name{getSummaryTable}
\alias{getSummaryTable}
\title{Get a Summary Table of Historical Stock Size}
\usage{
getSummaryTable(assessmentKey, ...)
}
\arguments{
\item{assessmentKey}{the unique identifier of the stock assessment}

\item{...}{to allow scope for back compatibility}
}
\value{
A data frame.
}
\description{
Get summary results of historical stock size, recruitment, and fishing
pressure.
}
\examples{
\dontrun{
assessmentKey <- findAssessmentKey("cod-2224", year = 2016)
sumtab <- getSummaryTable(assessmentKey)
head(sumtab)
attributes(sumtab)$notes
}
}
\seealso{
\code{\link{getSAG}} supports querying many years and quarters in one
  function call.

\code{\link{getListStocks}} and \code{\link{getFishStockReferencePoints}} get
  a list of stocks and reference points.

\code{\link{icesSAG-package}} gives an overview of the package.
}
\author{
Colin Millar and Scott Large.
}
