% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGraph.R
\name{getStandardAssessmentGraps}
\alias{getStandardAssessmentGraps}
\alias{getLandingsGraph}
\alias{getRecruitmentGraph}
\alias{getFishingMortalityGraph}
\alias{getSpawningStockBiomassGraph}
\alias{getFishMortality}
\alias{getstock_recruitment}
\alias{getYSSB}
\alias{getSSBHistoricalPerformance}
\alias{getFishingMortalityHistoricalPerformance}
\alias{getRecruitmentHistoricalPerformance}
\title{Get a Graph of Stock Assessment Output}
\usage{
getLandingsGraph(key)

getRecruitmentGraph(key)

getFishingMortalityGraph(key)

getSpawningStockBiomassGraph(key)

getFishMortality(key)

getstock_recruitment(key)

getYSSB(key)

getSSBHistoricalPerformance(key)

getFishingMortalityHistoricalPerformance(key)

getRecruitmentHistoricalPerformance(key)
}
\arguments{
\item{key}{the unique identifier of the stock assessment}
}
\value{
An array representing a bitmap.
}
\description{
Get a graph of stock assessment output, e.g., historical stock size,
recruitment, and fishing pressure.
}
\examples{
keys <- findKey("had", 2015)
landings_img <- getLandingsGraph(keys[1])
plot(landings_img)

landings_plots <- getLandingsGraph(keys)
plot(landings_plots)

}
\seealso{
\code{\link{getListStocks}} gets a list of stocks.

\code{\link{getFishStockReferencePoints}} gets biological reference points.

\code{\link{icesSAG-package}} gives an overview of the package.
}
