% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/condense.R
\name{condense}
\alias{condense}
\alias{condense.character}
\alias{condense.factor}
\alias{icd9_condense_decimal}
\title{Condense ICD-9 code by replacing complete families with parent codes}
\usage{
condense(x, short_code = guess_short(x), defined = NULL, warn = TRUE,
  ...)

\method{condense}{character}(x, short_code = guess_short(x),
  defined = NULL, ...)

\method{condense}{factor}(x, short_code = guess_short(x),
  defined = NULL, ...)

icd9_condense_decimal(x, defined = NULL, warn = TRUE,
  keep_factor_levels = FALSE)
}
\arguments{
\item{short_code}{single logical value which determines whether the ICD-9
code provided is in short (\code{TRUE}) or decimal (\code{FALSE}) form.
Where reasonable, this is guessed from the input data.}

\item{...}{arguments passed on to other functions}

\item{icd9}{is
a character vector or factor of ICD-9 codes. If fewer than five characters
is given in a code, then the digits are greedily assigned to hundreds, then
tens, then units, before the decimal parts. E.g., \code{10} becomes
\code{010}, not \code{0010} or \code{00010}.}

\item{icd9Short}{is a character vector of ICD-9 codes. If fewer than five
characters is given in a code, then the digits are greedily assigned to
hundreds, then tens, then units, before the decimal parts. E.g., \code{10}
becomes \code{010}, not \code{0010} or \code{00010}.}

\item{character}{vector of ICD-9 codes. If fewer than five
characters is given in a code, then the digits are greedily assigned to
hundreds, then tens, then units, before the decimal parts. E.g., \code{10}
becomes \code{010}, not \code{0010} or \code{00010}.}
}
\description{
These functions take a set of ICD codes, and look for parent ICD codes in the
hierarchy. If all the children of a parent are found, then the returned
vector will just contain the parents of those codes. Any additional codes
which did not have all the siblings present are retained. This can be thought
of as the inverse operation to \code{children}.
}
\section{Methods (by class)}{
\itemize{
\item \code{character}: Condense a set of ICD codes, guessing ICD version
from input data

\item \code{factor}: Condense a factor of ICD codes
}}

\examples{
kids <- children("V40")
kids
condense(kids, defined = TRUE)
kids_with_undefined <- children("V40", defined = FALSE)
head(kids_with_undefined)
length(kids_with_undefined)
condense(kids, defined = FALSE)

# what happens if we have additional codes?
# (condense will warn if we don't explicitly ask to condense
# based on defined or possible codes.)
condense(c(kids, "41100"), warn = FALSE)

# a good use is to summarise the contents of a comorbidity:
icd9_map_elix$CHF
condense(icd9_map_elix$CHF, warn = FALSE)
# explaining big groups of codes takes advantage of this:
explain_code(icd9_map_elix$CHF, condense = TRUE, warn = FALSE)
}
\seealso{
Other ICD-9 ranges: \code{\link{children}},
  \code{\link{expand_range}}
}
\concept{ICD-9 ranges}
\keyword{internal}
\keyword{manip}
