% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranges.R
\name{expand_minor}
\alias{expand_minor}
\alias{expand_minor.icd9}
\alias{expand_minor.icd10}
\title{expand decimal part of ICD-9 code to cover all possible sub-codes}
\usage{
expand_minor(mnr, ...)

\method{expand_minor}{icd9}(mnr, is_e = FALSE)

\method{expand_minor}{icd10}(x)
}
\arguments{
\item{minor}{character vector of 'minor' part of ICD-9 codes, i.e. that part
which falls after the decimal point, in decimal notation. (In 'short' five
digit notation, the 'major' part is the first three characters including
leading zeroes which may be inferred; the last two characters represent the
'minor' part.)}

\item{isE}{single logical, which if TRUE, treats the minor as part of an E
code (which is one character), as opposed to a V or numeric-only code,
which is two character. Default is \code{FALSE}.}
}
\value{
NA for invalid minor, otherwise a vector of all possible (perhaps
  non-existent) sub-divisions.
}
\description{
Accepts a single number or character input starting point for
  generation of all possible decimal parts of ICD9 code. e.g. giving an empty
  input will fill out 111 combinations, e..g .1 .11 .12 .... .2 ....
}
\section{Methods (by class)}{
\itemize{
\item \code{icd9}: expand minor parts of ICD-9 codes

\item \code{icd10}: expand minor parts of ICD-10 codes. Not implemented,
no obvious need, and ICD-10 children can be very complex.
}}

\examples{
\dontrun{
  # return all possible decimal parts of ICD9 codes (111 in total)
  length(icd:::expand_minor(as.icd9(""), is_e = FALSE))
  icd:::expand_minor(as.icd9("1")) # "1"  "10" "11" "12" "13" "14" "15" "16" "17" "18" "19"
}
}
\seealso{
Other ICD-9 ranges: \code{\link{children}},
  \code{\link{condense}}, \code{\link{expand_range}}
}
\concept{ICD-9 ranges}
\keyword{internal}
\keyword{manip}
