% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{icd_filter_valid}
\alias{icd_filter_valid}
\alias{icd_filter_invalid}
\alias{icd9_filter_valid}
\alias{icd10_filter_valid}
\alias{icd9_filter_invalid}
\alias{icd10_filter_invalid}
\title{Filter ICD codes by validity.}
\usage{
icd_filter_valid(x, icd_name = get_icd_name(x),
  short_code = icd_guess_short(.subset2(x, icd_name)), invert = FALSE)

icd_filter_invalid(x, icd_name = get_icd_name(x),
  short_code = icd_guess_short(x[[icd_name]]), invert = FALSE)

icd9_filter_valid(x, icd_name = get_icd_name(x),
  short_code = icd_guess_short(x[[icd_name]]), invert = FALSE)

icd10_filter_valid(x, icd_name = get_icd_name(x),
  short_code = icd_guess_short(x[[icd_name]]), invert = FALSE)

icd9_filter_invalid(x, icd_name = get_icd_name(x),
  short_code = icd_guess_short(x[[icd_name]]), invert = FALSE)

icd10_filter_invalid(x, icd_name = get_icd_name(x),
  short_code = icd_guess_short(x[[icd_name]]), invert = FALSE)
}
\arguments{
\item{x}{input vector of ICD codes}

\item{icd_name}{The name of the column in the \code{data.frame} which
contains the ICD codes. This is a character vector of length one. If it is
\code{NULL}, \code{icd9} will attempt to guess the column name, looking for
progressively less likely possibilities until it matches a single column.
Failing this, it will take the first column in the data frame. Specifying
the column using this argument avoids the guesswork.}

\item{short_code}{single logical value which determines whether the ICD-9
code provided is in short (\code{TRUE}) or decimal (\code{FALSE}) form.
Where reasonable, this is guessed from the input data.}

\item{invert}{Single logical value. Returns the inverse of the result. E.g.
if seeking valid ICD-9 codes, the invalid ones are returned.}

\item{...}{arguments passed to the class-specific functions}
}
\description{
Filters a data.frame of patients for valid or invalid ICD-9
  codes
}
\section{Functions}{
\itemize{
\item \code{icd_filter_invalid}: Filter invalid rows from data frame of patients with ICD codes.
This can also be achieved with \code{icd_filter_valid} and \code{invert = TRUE}

\item \code{icd9_filter_valid}: Filter data frame for valid ICD codes
}}

\keyword{manip}
