% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calmarFunctions.R
\name{regroupCalibrationModalities}
\alias{regroupCalibrationModalities}
\title{Regroup calibration modalities}
\usage{
regroupCalibrationModalities(calibrationMatrix, marginMatrix,
  calibrationVariable, vecModalities, newModality)
}
\arguments{
\item{calibrationMatrix}{calibration matrix}

\item{marginMatrix}{matrix containing the margins to the Icarus format}

\item{calibrationVariable}{name of the calibration varaible for which regroupment has to be done}

\item{vecModalities}{Initial modalities of the variable}

\item{newModality}{Regrouped modalities of the variable}
}
\description{
Beware, this function modifies the calibrationMatrix and marginMatrix objects entered in parameter?
Regroups modalities entered in "vecModalities" into single
"newModality" in "calibrationMatrix" and adapts "marginMatrix" to the new concept.
Typical usage is right before a calibration (and after comptutation of marginMatrix), when
you realise calibration output is better when several modalities are reduced to one.
(typically very rare modalities, on which calibration constraints are very restrictive).
Uses pseudo-"call by reference" via eval.parent because 2 objects are modified :
calibrationMatrix and marginMatrix
}
\examples{
## Suppose we have a calibration matrix and a margin matrix containing information
## for two categorical variables "X1" (10 modalities) and "X2" (5 modalities)

matrixCal <- data.frame(matrix(
               c(floor(10*runif(100))+1,floor((5)*runif(100))+1,
               floor(10*runif(100))+1,rep(10,100)),
               ncol=4))
marginMatrix <- matrix(c("X1",10,rep(1/10,10),
                 "X2",5,rep(1/5,5),rep(0,5)), nrow=2, byrow=TRUE)

# table(matrixCal$X1)
# 1  2  3  4  5  6  7  8  9 10 
# 9  8  8  8 11 15 13  6 10 12 
# marginMatrix
# [,1] [,2] [,3]  [,4]  [,5]  [,6]  [,7]  [,8]  [,9]  [,10] [,11] [,12]
# [1,] "X1" "10" "0.1" "0.1" "0.1" "0.1" "0.1" "0.1" "0.1" "0.1" "0.1" "0.1"
# [2,] "X2" "5"  "0.2" "0.2" "0.2" "0.2" "0.2" "0"   "0"   "0"   "0"   "0" 

regroupCalibrationModalities(matrixCal, marginMatrix, "X1", c(3,4,8), "0")

# table(matrixCal$X1)
# 0  1  2  5  6  7  9 10 
# 22  9  8 11 15 13 10 12 
# marginMatrix
# [,1] [,2] [,3]  [,4]  [,5]  [,6]  [,7]  [,8]  [,9]  [,10]
# [1,] "X1" "8"  "0.3" "0.1" "0.1" "0.1" "0.1" "0.1" "0.1" "0.1"
# [2,] "X2" "5"  "0.2" "0.2" "0.2" "0.2" "0.2" "0"   "0"   "0"  

}

