% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate.R
\name{reorder_levels}
\alias{reorder_levels}
\title{Reorder the levels of a categorical variable}
\usage{
reorder_levels(
  data,
  var,
  new_levels = NULL,
  auto = c("freq", "order", "seq"),
  name = NULL
)
}
\arguments{
\item{data}{a dataframe to reorder}

\item{var}{a categorical variable to reorder}

\item{new_levels}{a character vector of the new factor order;
overrides \code{auto} if not \code{NULL}}

\item{auto}{only meaningful if \code{new_levels} is \code{NULL}: the method
to auto-reorder the levels, see \code{\link[forcats]{fct_inorder}}}

\item{name}{name for the new variable}
}
\value{
original dataframe containing a new column of the reordered
        categorical variable with tidyverse code attached
}
\description{
Reorder the levels of a categorical variable either manually or automatically
}
\examples{
reordered <- reorder_levels(iris,
    var = "Species",
    new_levels = c("versicolor", "virginica", "setosa")
)
cat(code(reordered))
head(reordered)

reordered <- reorder_levels(iris,
    var = "Species",
    auto = "freq"
)
cat(code(reordered))
head(reordered)

}
\seealso{
\code{\link{code}}
}
\author{
Zhaoming Su
}
