% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate.R
\name{create_vars}
\alias{create_vars}
\title{Create new variables}
\usage{
create_vars(data, vars = ".new_var", vars_expr = NULL)
}
\arguments{
\item{data}{a dataframe to which to add new variables to}

\item{vars}{a character of the new variable names}

\item{vars_expr}{a character of valid R expressions which can
generate vectors of values}
}
\value{
original dataframe containing the new columns
        created from \code{vars_expr}
with tidyverse code attached
}
\description{
Create new variables by using valid R expressions and returns
the result along with tidyverse code used to generate it.
}
\examples{
created <- create_vars(
    data = iris,
    vars = "Sepal.Length_less_Sepal.Width",
    "Sepal.Length - Sepal.Width"
)
cat(code(created))
head(created)
}
\seealso{
\code{\link{code}}
}
\author{
Zhaoming Su
}
