/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdistmulti.norta;

import umontreal.iro.lecuyer.probdist.DiscreteDistributionInt;
import umontreal.iro.lecuyer.probdistmulti.norta.NortaInitDisc;

public class NI3
extends NortaInitDisc {
    private double tolerance;

    public NI3(double rX, DiscreteDistributionInt dist1, DiscreteDistributionInt dist2, double tr, double tolerance) {
        super(rX, dist1, dist2, tr);
        this.tolerance = tolerance;
        this.computeParams();
    }

    public double computeCorr() {
        double dxold;
        double xh;
        double xl;
        double ITMAX = 100.0;
        double b = 0.0;
        double ccc = this.rX * this.sd1 * this.sd2 + this.mu1 * this.mu2;
        if (this.rX == 0.0) {
            return 0.0;
        }
        if (this.rX > 0.0) {
            xl = 0.0;
            xh = 1.0;
        } else {
            xl = -1.0;
            xh = 0.0;
        }
        b = 2.0 * Math.sin(Math.PI * this.rX / 6.0);
        double dx = dxold = xh - xl;
        double f = this.integ(b) - ccc;
        double df = this.deriv(b);
        int i = 1;
        while ((double)i <= 100.0) {
            if (((b - xh) * df - f) * ((b - xl) * df - f) > 0.0 || Math.abs(2.0 * f) > Math.abs(dxold * df)) {
                dxold = dx;
                dx = 0.5 * (xh - xl);
                b = xl + dx;
                if (xl == b) {
                    return b;
                }
            } else {
                dxold = dx;
                double temp = b;
                dx = f / df;
                if (temp == (b -= dx)) {
                    return b;
                }
            }
            if (Math.abs(dx) < this.tolerance) {
                return b;
            }
            f = this.integ(b) - ccc;
            df = this.deriv(b);
            if (f < 0.0) {
                xl = b;
            } else {
                xh = b;
            }
            ++i;
        }
        return b;
    }

    public String toString() {
        String desc = super.toString();
        desc = desc + "tolerance : " + this.tolerance + "\n";
        return desc;
    }
}

