/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.stochprocess;

import umontreal.iro.lecuyer.randvar.NormalGen;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.stochprocess.OrnsteinUhlenbeckProcess;

public class OrnsteinUhlenbeckProcessEuler
extends OrnsteinUhlenbeckProcess {
    public OrnsteinUhlenbeckProcessEuler(double x0, double alpha, double b, double sigma, RandomStream stream) {
        this(x0, alpha, b, sigma, new NormalGen(stream));
    }

    public OrnsteinUhlenbeckProcessEuler(double x0, double alpha, double b, double sigma, NormalGen gen) {
        super(x0, alpha, b, sigma, gen);
    }

    public double nextObservation() {
        double xOld = this.path[this.observationIndex];
        double x = xOld + (this.beta - xOld) * this.alphadt[this.observationIndex] + this.sigmasqrdt[this.observationIndex] * this.gen.nextDouble();
        ++this.observationIndex;
        this.path[this.observationIndex] = x;
        return x;
    }

    public double nextObservation(double nextTime) {
        double x;
        double previousTime = this.t[this.observationIndex];
        double xOld = this.path[this.observationIndex];
        ++this.observationIndex;
        this.t[this.observationIndex] = nextTime;
        double dt = nextTime - previousTime;
        this.path[this.observationIndex] = x = xOld + this.alpha * (this.beta - xOld) * dt + this.sigma * Math.sqrt(dt) * this.gen.nextDouble();
        return x;
    }

    public double nextObservation(double x, double dt) {
        x = x + this.alpha * (this.beta - x) * dt + this.sigma * Math.sqrt(dt) * this.gen.nextDouble();
        return x;
    }

    public double[] generatePath() {
        double xOld = this.x0;
        for (int j = 0; j < this.d; ++j) {
            double x;
            this.path[j + 1] = x = xOld + (this.beta - xOld) * this.alphadt[j] + this.sigmasqrdt[j] * this.gen.nextDouble();
            xOld = x;
        }
        this.observationIndex = this.d;
        return this.path;
    }

    protected void initArrays(int d) {
        for (int j = 0; j < d; ++j) {
            double dt = this.t[j + 1] - this.t[j];
            this.alphadt[j] = this.alpha * dt;
            this.sigmasqrdt[j] = this.sigma * Math.sqrt(dt);
        }
    }
}

