/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.simprocs;

import java.util.ListIterator;
import umontreal.iro.lecuyer.simevents.Accumulate;
import umontreal.iro.lecuyer.simevents.LinkedListStat;
import umontreal.iro.lecuyer.simevents.Simulator;
import umontreal.iro.lecuyer.simprocs.ProcessSimulator;
import umontreal.iro.lecuyer.simprocs.SimProcess;
import umontreal.iro.lecuyer.simprocs.UserRecord;
import umontreal.iro.lecuyer.stat.Tally;
import umontreal.iro.lecuyer.util.PrintfFormat;

public class Bin {
    private static final int FIFO = 1;
    private static final int LIFO = 2;
    private ProcessSimulator sim;
    private String name;
    private int available = 0;
    private int policy = 1;
    private LinkedListStat<UserRecord> waitingList;
    private ListIterator<UserRecord> iter;
    private Accumulate statAvail;
    private boolean stats;
    private double initStatTime;

    public Bin() {
        this("");
    }

    public Bin(ProcessSimulator sim) {
        this(sim, "");
    }

    public Bin(String name) {
        try {
            ProcessSimulator.initDefault();
            this.sim = (ProcessSimulator)Simulator.getDefaultSimulator();
            this.waitingList = new LinkedListStat(this.sim);
            this.name = name;
            this.iter = this.waitingList.listIterator();
            this.stats = false;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Wrong default Simulator type");
        }
    }

    public Bin(ProcessSimulator sim, String name) {
        this.sim = sim;
        this.waitingList = new LinkedListStat(sim);
        this.name = name;
        this.iter = this.waitingList.listIterator();
        this.stats = false;
    }

    public void init() {
        int oldAvail = this.available;
        this.waitingList.clear();
        this.available = 0;
        if (this.stats) {
            this.initStat();
        }
    }

    public void setStatCollecting(boolean b) {
        if (b) {
            if (this.stats) {
                throw new IllegalStateException("Already collecting statistics for this resource");
            }
            this.stats = true;
            this.waitingList.setStatCollecting(true);
            if (this.statAvail != null) {
                this.initStat();
            } else {
                this.statAvail = new Accumulate(this.sim, "StatOnAvail");
                this.statAvail.update(this.available);
            }
        } else {
            if (this.stats) {
                throw new IllegalStateException("Not collecting statistics for this resource");
            }
            this.stats = false;
            this.waitingList.setStatCollecting(false);
        }
    }

    public void initStat() {
        if (!this.stats) {
            throw new IllegalStateException("Not collecting statistics for this resource");
        }
        this.statAvail.init();
        this.statAvail.update(this.available);
        this.waitingList.initStat();
        this.initStatTime = this.sim.time();
    }

    public void setPolicyFIFO() {
        this.policy = 1;
    }

    public void setPolicyLIFO() {
        this.policy = 2;
    }

    public int getAvailable() {
        return this.available;
    }

    public void take(int n) {
        SimProcess p = this.sim.currentProcess();
        if (n <= this.available) {
            this.available -= n;
            if (this.stats) {
                this.statAvail.update(this.available);
                this.waitingList.statSojourn().add(0.0);
            }
        } else {
            UserRecord record = new UserRecord(n, p, this.sim.time());
            switch (this.policy) {
                case 1: {
                    this.waitingList.addLast(record);
                    break;
                }
                case 2: {
                    this.waitingList.addFirst(record);
                    break;
                }
                default: {
                    throw new IllegalStateException("the policy must be LIFO or FIFO");
                }
            }
            p.suspend();
        }
    }

    public void put(int n) {
        this.available += n;
        if (this.stats) {
            this.statAvail.update(this.available);
        }
        if (this.waitingList.size() > 0) {
            this.wakeProcess();
        }
    }

    private void wakeProcess() {
        ListIterator iter = this.waitingList.listIterator();
        while (iter.hasNext() && this.available > 0) {
            UserRecord record = (UserRecord)iter.next();
            if (!record.process.isAlive()) {
                throw new IllegalStateException("process not alive");
            }
            if (record.numUnits > this.available) continue;
            record.process.resume();
            this.available -= record.numUnits;
            if (this.stats) {
                this.statAvail.update(this.available);
            }
            iter.remove();
        }
    }

    public LinkedListStat waitList() {
        return this.waitingList;
    }

    public Accumulate statOnAvail() {
        return this.statAvail;
    }

    public String report() {
        if (this.statAvail == null) {
            throw new IllegalStateException("Asking a report for a bin for which setStatCollecting (true) has not been called");
        }
        Accumulate sizeWait = this.waitingList.statSize();
        Tally sojWait = this.waitingList.statSojourn();
        PrintfFormat str = new PrintfFormat();
        str.append("REPORT ON BIN : ").append(this.name).append(PrintfFormat.NEWLINE);
        str.append("   From time : ").append(7, 2, 2, this.initStatTime);
        str.append("   to time : ");
        str.append(10, 2, 2, this.sim.time());
        str.append(PrintfFormat.NEWLINE + "                    min        max     average  ");
        str.append("standard dev.  nb. obs.");
        str.append(PrintfFormat.NEWLINE + "   Available tokens ");
        str.append(8, (int)(this.statAvail.min() + 0.5));
        str.append(11, (int)(this.statAvail.max() + 0.5));
        str.append(12, 3, 2, this.statAvail.average());
        str.append(PrintfFormat.NEWLINE + "   Queue Size  ");
        str.append(8, (int)(sizeWait.min() + 0.5));
        str.append(11, (int)(sizeWait.max() + 0.5));
        str.append(12, 3, 2, sizeWait.average());
        str.append(PrintfFormat.NEWLINE + "   Wait    ");
        str.append(12, 3, 2, sojWait.min()).append(' ');
        str.append(10, 3, 2, sojWait.max()).append(' ');
        str.append(11, 3, 2, sojWait.average()).append(' ');
        str.append(10, 3, 2, sojWait.standardDeviation());
        str.append(10, sojWait.numberObs());
        return str.toString();
    }

    public Simulator simulator() {
        return this.sim;
    }

    public void setSimulator(ProcessSimulator sim) {
        this.sim = sim;
    }
}

