/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.charts;

import cern.colt.list.DoubleArrayList;
import java.awt.Color;
import java.util.Formatter;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.data.statistics.HistogramBin;
import umontreal.iro.lecuyer.charts.CustomHistogramDataset;
import umontreal.iro.lecuyer.charts.SSJXYSeriesCollection;
import umontreal.iro.lecuyer.stat.TallyHistogram;
import umontreal.iro.lecuyer.stat.TallyStore;
import umontreal.iro.lecuyer.util.Num;

public class HistogramSeriesCollection
extends SSJXYSeriesCollection {
    protected boolean[] filled;
    protected double[] lineWidth;
    protected int numBin = 20;

    private int calcNumBins(int n) {
        int numbins = (int)Math.ceil(1.0 + Num.log2(n));
        if (n > 5000) {
            numbins *= 2;
        }
        return numbins;
    }

    private double[] countersToArray(TallyHistogram hist) {
        int nb = hist.getNumBins();
        double binwidth = (hist.getB() - hist.getA()) / (double)nb;
        int[] count = hist.getCounters();
        int sum = 0;
        for (int i = 1; i <= nb; ++i) {
            sum += count[i];
        }
        double[] data = new double[sum];
        int k = 0;
        for (int i = 1; i <= nb; ++i) {
            int j;
            double h = binwidth;
            double base = hist.getA() + (double)(i - 1) * binwidth;
            if (count[i] > 0) {
                h /= (double)count[i];
            }
            if (i == nb) {
                for (j = 0; j < count[i]; ++j) {
                    data[k++] = hist.getB() - (double)j * h;
                }
                continue;
            }
            for (j = 0; j < count[i]; ++j) {
                data[k++] = base + (double)j * h;
            }
        }
        return data;
    }

    public HistogramSeriesCollection() {
        this.renderer = new XYBarRenderer();
        this.seriesCollection = new CustomHistogramDataset();
    }

    public HistogramSeriesCollection(double[] ... data) {
        int i;
        this.seriesCollection = new CustomHistogramDataset();
        this.renderer = new XYBarRenderer();
        CustomHistogramDataset tempSeriesCollection = (CustomHistogramDataset)this.seriesCollection;
        for (i = 0; i < data.length; ++i) {
            this.numBin = this.calcNumBins(data[i].length);
            tempSeriesCollection.addSeries((Comparable)Integer.valueOf(i), data[i], this.numBin);
        }
        for (i = 0; i < tempSeriesCollection.getSeriesCount(); ++i) {
            this.renderer.setSeriesPaint(i, HistogramSeriesCollection.getDefaultColor(i));
        }
        this.filled = new boolean[this.seriesCollection.getSeriesCount()];
        this.lineWidth = new double[this.seriesCollection.getSeriesCount()];
        for (i = 0; i < tempSeriesCollection.getSeriesCount(); ++i) {
            this.filled[i] = false;
            this.lineWidth[i] = 0.5;
            this.setFilled(i, false);
        }
    }

    public HistogramSeriesCollection(double[] data, int numPoints) {
        int i;
        this.seriesCollection = new CustomHistogramDataset();
        this.renderer = new XYBarRenderer();
        CustomHistogramDataset tempSeriesCollection = (CustomHistogramDataset)this.seriesCollection;
        this.numBin = this.calcNumBins(numPoints);
        tempSeriesCollection.addSeries((Comparable)Integer.valueOf(0), data, numPoints, this.numBin);
        for (i = 0; i < tempSeriesCollection.getSeriesCount(); ++i) {
            this.renderer.setSeriesPaint(i, HistogramSeriesCollection.getDefaultColor(i));
        }
        this.filled = new boolean[this.seriesCollection.getSeriesCount()];
        this.lineWidth = new double[this.seriesCollection.getSeriesCount()];
        for (i = 0; i < tempSeriesCollection.getSeriesCount(); ++i) {
            this.filled[i] = false;
            this.lineWidth[i] = 0.5;
            this.setFilled(i, false);
        }
    }

    public HistogramSeriesCollection(DoubleArrayList ... data) {
        int i;
        this.seriesCollection = new CustomHistogramDataset();
        this.renderer = new XYBarRenderer();
        CustomHistogramDataset tempSeriesCollection = (CustomHistogramDataset)this.seriesCollection;
        for (i = 0; i < data.length; ++i) {
            this.numBin = this.calcNumBins(data[i].size());
            tempSeriesCollection.addSeries((Comparable)Integer.valueOf(i), data[i].elements(), data[i].size(), this.numBin);
        }
        for (i = 0; i < tempSeriesCollection.getSeriesCount(); ++i) {
            this.renderer.setSeriesPaint(i, HistogramSeriesCollection.getDefaultColor(i));
        }
        this.filled = new boolean[this.seriesCollection.getSeriesCount()];
        this.lineWidth = new double[this.seriesCollection.getSeriesCount()];
        for (i = 0; i < tempSeriesCollection.getSeriesCount(); ++i) {
            this.filled[i] = false;
            this.lineWidth[i] = 0.5;
            this.setFilled(i, false);
        }
    }

    public HistogramSeriesCollection(TallyStore ... tallies) {
        int i;
        this.seriesCollection = new CustomHistogramDataset();
        this.renderer = new XYBarRenderer();
        CustomHistogramDataset tempSeriesCollection = (CustomHistogramDataset)this.seriesCollection;
        for (i = 0; i < tallies.length; ++i) {
            double h = 3.5 * tallies[i].standardDeviation() / Math.pow(tallies[i].numberObs(), 0.3333333333333333);
            this.numBin = (int)((tallies[i].max() - tallies[i].min()) / (1.5 * h));
            tempSeriesCollection.addSeries(Integer.valueOf(i), tallies[i].getArray(), tallies[i].numberObs(), this.numBin, tallies[i].min(), tallies[i].max());
        }
        for (i = 0; i < tempSeriesCollection.getSeriesCount(); ++i) {
            this.renderer.setSeriesPaint(i, HistogramSeriesCollection.getDefaultColor(i));
        }
        this.filled = new boolean[this.seriesCollection.getSeriesCount()];
        this.lineWidth = new double[this.seriesCollection.getSeriesCount()];
        for (i = 0; i < tempSeriesCollection.getSeriesCount(); ++i) {
            this.filled[i] = false;
            this.lineWidth[i] = 0.5;
            this.setFilled(i, false);
        }
    }

    public HistogramSeriesCollection(TallyHistogram ... tallies) {
        int i;
        this.seriesCollection = new CustomHistogramDataset();
        this.renderer = new XYBarRenderer();
        CustomHistogramDataset tempSeriesCollection = (CustomHistogramDataset)this.seriesCollection;
        for (i = 0; i < tallies.length; ++i) {
            double[] data = this.countersToArray(tallies[i]);
            tempSeriesCollection.addSeries(Integer.valueOf(i), data, data.length, tallies[i].getNumBins(), tallies[i].getA(), tallies[i].getB());
        }
        for (i = 0; i < tempSeriesCollection.getSeriesCount(); ++i) {
            this.renderer.setSeriesPaint(i, HistogramSeriesCollection.getDefaultColor(i));
        }
        this.filled = new boolean[this.seriesCollection.getSeriesCount()];
        this.lineWidth = new double[this.seriesCollection.getSeriesCount()];
        for (i = 0; i < tempSeriesCollection.getSeriesCount(); ++i) {
            this.filled[i] = false;
            this.lineWidth[i] = 0.5;
            this.setFilled(i, false);
        }
    }

    public HistogramSeriesCollection(CustomHistogramDataset data) {
        int i;
        this.renderer = new XYBarRenderer();
        this.seriesCollection = data;
        for (i = 0; i < data.getSeriesCount(); ++i) {
            this.renderer.setSeriesPaint(i, HistogramSeriesCollection.getDefaultColor(i));
        }
        this.filled = new boolean[this.seriesCollection.getSeriesCount()];
        this.lineWidth = new double[this.seriesCollection.getSeriesCount()];
        for (i = 0; i < data.getSeriesCount(); ++i) {
            this.filled[i] = false;
            this.lineWidth[i] = 0.5;
            this.setFilled(i, false);
        }
    }

    public int add(double[] data) {
        return this.add(data, data.length);
    }

    public int add(double[] data, int numPoints) {
        CustomHistogramDataset tempSeriesCollection = (CustomHistogramDataset)this.seriesCollection;
        tempSeriesCollection.addSeries((Comparable)Integer.valueOf(tempSeriesCollection.getSeriesCount()), data, numPoints, this.numBin);
        boolean[] newFilled = new boolean[this.seriesCollection.getSeriesCount()];
        double[] newLineWidth = new double[this.seriesCollection.getSeriesCount()];
        int j = this.seriesCollection.getSeriesCount() - 1;
        this.renderer.setSeriesPaint(j, HistogramSeriesCollection.getDefaultColor(j));
        newFilled[j] = false;
        newLineWidth[j] = 0.5;
        for (j = 0; j < this.seriesCollection.getSeriesCount() - 1; ++j) {
            newFilled[j] = this.filled[j];
            newLineWidth[j] = this.lineWidth[j];
        }
        this.filled = newFilled;
        this.lineWidth = newLineWidth;
        return this.seriesCollection.getSeriesCount() - 1;
    }

    public int add(DoubleArrayList observationSet) {
        return this.add(observationSet.elements(), observationSet.size());
    }

    public int add(TallyStore tally) {
        return this.add(tally.getArray(), tally.numberObs());
    }

    public CustomHistogramDataset getSeriesCollection() {
        return (CustomHistogramDataset)this.seriesCollection;
    }

    public List getBins(int series) {
        return ((CustomHistogramDataset)this.seriesCollection).getBins(series);
    }

    public void setBins(int series, int bins) {
        ((CustomHistogramDataset)this.seriesCollection).setBins(series, bins);
    }

    public void setBins(int series, int bins, double minimum, double maximum) {
        ((CustomHistogramDataset)this.seriesCollection).setBins(series, bins, minimum, maximum);
    }

    public void setBins(int series, HistogramBin[] binsTable) {
        ((CustomHistogramDataset)this.seriesCollection).setBins(series, binsTable);
    }

    public List getValuesList(int series) {
        return ((CustomHistogramDataset)this.seriesCollection).getValuesList(series);
    }

    public double[] getValues(int series) {
        return ((CustomHistogramDataset)this.seriesCollection).getValues(series);
    }

    public void setValues(int series, List valuesList) {
        ((CustomHistogramDataset)this.seriesCollection).setValues(series, valuesList);
    }

    public void setValues(int series, double[] values) {
        ((CustomHistogramDataset)this.seriesCollection).setValues(series, values);
    }

    public boolean getFilled(int series) {
        return this.filled[series];
    }

    public void setFilled(int series, boolean filled) {
        this.filled[series] = filled;
    }

    public double getMargin() {
        return ((XYBarRenderer)this.renderer).getMargin();
    }

    public void setMargin(double margin) {
        ((XYBarRenderer)this.renderer).setMargin(margin);
    }

    public double getOutlineWidth(int series) {
        return this.lineWidth[series];
    }

    public void setOutlineWidth(int series, double outline) {
        this.lineWidth[series] = outline;
    }

    public String toLatex(double XScale, double YScale, double XShift, double YShift, double xmin, double xmax, double ymin, double ymax) {
        xmin = Math.min(XShift, xmin);
        xmax = Math.max(XShift, xmax);
        ymin = Math.min(YShift, ymin);
        ymax = Math.max(YShift, ymax);
        CustomHistogramDataset tempSeriesCollection = (CustomHistogramDataset)this.seriesCollection;
        Formatter formatter = new Formatter(Locale.US);
        double margin = ((XYBarRenderer)this.renderer).getMargin();
        for (int i = tempSeriesCollection.getSeriesCount() - 1; i >= 0; --i) {
            List temp = tempSeriesCollection.getBins(i);
            ListIterator iter = temp.listIterator();
            Color color = (Color)this.renderer.getSeriesPaint(i);
            String colorString = HistogramSeriesCollection.detectXColorClassic(color);
            if (colorString == null) {
                colorString = "color" + i;
                formatter.format("\\definecolor{%s}{rgb}{%.2f, %.2f, %.2f}%n", colorString, (double)color.getRed() / 255.0, (double)color.getGreen() / 255.0, (double)color.getBlue() / 255.0);
            }
            HistogramBin currentBin = null;
            while (iter.hasNext()) {
                double var;
                currentBin = (HistogramBin)iter.next();
                double currentMargin = margin * (currentBin.getEndBoundary() - currentBin.getStartBoundary()) * XScale;
                if (currentBin.getStartBoundary() >= xmin && currentBin.getStartBoundary() <= xmax && (double)currentBin.getCount() >= ymin && (double)currentBin.getCount() <= ymax) {
                    var = Math.min(currentBin.getEndBoundary(), xmax);
                    if (this.filled[i]) {
                        formatter.format("\\filldraw [line width=%.2fpt, opacity=%.2f, color=%s] ([xshift=%.4f] %.4f, %.4f) rectangle ([xshift=-%.4f] %.4f, %.4f); %%%n", this.lineWidth[i], (double)color.getAlpha() / 255.0, colorString, currentMargin, (currentBin.getStartBoundary() - XShift) * XScale, 0.0, currentMargin, (var - XShift) * XScale, ((double)currentBin.getCount() - YShift) * YScale);
                        continue;
                    }
                    formatter.format("\\draw [line width=%.2fpt, color=%s] ([xshift=%.4f] %.4f, %.4f) rectangle ([xshift=-%.4f] %.4f, %.4f); %%%n", this.lineWidth[i], colorString, currentMargin, (currentBin.getStartBoundary() - XShift) * XScale, 0.0, currentMargin, (var - XShift) * XScale, ((double)currentBin.getCount() - YShift) * YScale);
                    continue;
                }
                if (!(currentBin.getStartBoundary() >= xmin) || !(currentBin.getStartBoundary() <= xmax) || !((double)currentBin.getCount() >= ymin) || !((double)currentBin.getCount() > ymax)) continue;
                var = Math.min(currentBin.getEndBoundary(), xmax);
                if (this.filled[i]) {
                    formatter.format("\\filldraw [line width=%.2fpt,  opacity=%.2f, color=%s] ([xshift=%.4f] %.4f, %.4f) rectangle ([xshift=-%.4f] %.4f, %.4f); %%%n", this.lineWidth[i], (double)color.getAlpha() / 255.0, colorString, currentMargin, (currentBin.getStartBoundary() - XShift) * XScale, 0.0, currentMargin, (var - XShift) * XScale, (ymax - YShift) * YScale);
                    formatter.format("\\draw [line width=%.2fpt, color=%s, style=dotted] ([xshift=%.4f] %.4f, %.4f) rectangle ([yshift=3mm, xshift=-%.4f] %.4f, %.4f); %%%n", this.lineWidth[i], colorString, currentMargin, (currentBin.getStartBoundary() - XShift) * XScale, (ymax - YShift) * YScale, currentMargin, (var - XShift) * XScale, (ymax - YShift) * YScale);
                    continue;
                }
                formatter.format("\\draw [line width=%.2fpt, color=%s] ([xshift=%.4f] %.4f, %.4f) rectangle ([xshift=-%.4f] %.4f, %.4f); %%%n", this.lineWidth[i], colorString, currentMargin, (currentBin.getStartBoundary() - XShift) * XScale, 0.0, currentMargin, (var - XShift) * XScale, (ymax - YShift) * YScale);
                formatter.format("\\draw [line width=%.2fpt, color=%s, style=dotted] ([xshift=%.4f] %.4f, %.4f) rectangle ([yshift=3mm, xshift=-%.4f] %.4f, %.4f); %%%n", this.lineWidth[i], colorString, currentMargin, (currentBin.getStartBoundary() - XShift) * XScale, (ymax - YShift) * YScale, currentMargin, (var - XShift) * XScale, (ymax - YShift) * YScale);
            }
        }
        return formatter.toString();
    }
}

